/* +FHDR-----------------------------------------------------------------------
* Copyright (c) 2011, Freescale Semiconductor, Inc.
* ----------------------------------------------------------------------------
* FILE NAME : Fifo.h
* AUTHOR    : Freescale Semiconductor, Inc.
* ----------------------------------------------------------------------------
* RELEASE HISTORY
* VERSION DATE AUTHOR DESCRIPTION
* (1.0) 11/01/2011   B32599 (Initial Template)
* ----------------------------------------------------------------------------
* KEYWORDS : Xtrinsic
* ----------------------------------------------------------------------------
* PURPOSE:
* ----------------------------------------------------------------------------
* REUSE ISSUES
*
* -FHDR-----------------------------------------------------------------------
*/

#ifndef FIFO_H_
#define FIFO_H_


/******************************************************************************
*******************************************************************************
*                             FIFO					                          *
*******************************************************************************
*******************************************************************************/


/******************************************************************************
* Public type definitions
*******************************************************************************/

/* ----------------------------------------------------------------------------
 * FIFO output structure
 * ----------------------------------------------------------------------------*/


typedef struct fifo_status_bits_tag
{
  uint8_t wmrk_flag     :1;
  uint8_t empty_flag    :1;
  uint8_t ovf_flag      :1;
  uint8_t reserved      :3;
  uint8_t on_going_pop  :1;
  uint8_t on_going_push :1;
}fifo_status_bits_t;

typedef union fifo_status_byte_tag
{
  uint8_t Byte;
  fifo_status_bits_t bits;
}fifo_status_byte_t;

typedef struct fifo_out_struct_tag
{
  uint16_t records_number;
  uint8_t entry_size;
  fifo_status_byte_t status;
}fifo_outs_t;


/* ----------------------------------------------------------------------------
 * Data FIFO parameter structure
 * ----------------------------------------------------------------------------*/

typedef struct config_bits_tag{
  uint8_t mode  :2;
  uint8_t ch1_sz:2;
  uint8_t rsrvd :4;
}config_bits_t;

typedef union config_tag{
  config_bits_t bits;
  uint8_t       Byte;
}config_t;

typedef struct dataFifo_int_tag{
  config_t		config;
  uint8_t       reserved1;
  uint8_t       reserved2;
  uint8_t       reserved3;
  uint16_t      sz;
  uint8_t       ch1_app_id;
  uint8_t       reserved4;
  uint16_t      wmrk;
}dataFifo_param_t;

/* ----------------------------------------------------------------------------
 * Data FIFO structure
 * ----------------------------------------------------------------------------*/

typedef struct dataFifo_struct_tag
{
  fifo_outs_t outs;
  dataFifo_param_t param;
}dataFifo_struct_t;


/* ----------------------------------------------------------------------------
 * Event FIFO parameter structure
 * ----------------------------------------------------------------------------*/

typedef struct eventFifo_int_tag
{
  uint16_t sz;
  uint16_t wmrk;
  uint16_t time_out;
}eventFifo_param_t;

/* ----------------------------------------------------------------------------
 * Event FIFO structure
 * ----------------------------------------------------------------------------*/

typedef struct eventFifo_struct_tag
{
  fifo_outs_t outs;
  eventFifo_param_t param;
}eventFifo_struct_t;


#endif /* FIFO_H_*/
