/****************************************************************************************************/
/**
Copyright (c) 2008 Freescale Semiconductor
Freescale Confidential Proprietary
\file       S08_Flash.h
\brief      
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     
\version    1.0
\date       September/2008
*/
/****************************************************************************************************/
/*                                                                                                  */
/* All software, source code, included documentation, and any implied know-how are property of      */
/* Freescale Semiconductor and therefore considered CONFIDENTIAL INFORMATION.                       */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY.                      */
/*                                                                                                  */
/* All Confidential Information remains the property of Freescale Semiconductor and will not be     */
/* copied or reproduced without the express written permission of the Discloser, except for copies  */
/* that are absolutely necessary in order to fulfill the Purpose.                                   */
/*                                                                                                  */
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.     */
/* CUSTOMER retains the final decision relative to the total design and functionality of the end    */
/* product.                                                                                         */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/

/*****************************************************************************************************
* Module definition against multiple inclusion
*****************************************************************************************************/
#ifndef __S08_FLASH__
  #define __S08_FLASH__
  
/*****************************************************************************************************
* Include files
*****************************************************************************************************/  
  #include "derivative.h"
  
/*****************************************************************************************************
* Declaration of project wide TYPES
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of project wide VARIABLES
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of project wide MACROS / #DEFINE-CONSTANTS 
*****************************************************************************************************/
  #define FLASH_MASS_ERASE_CMD  0x41
  #define FLASH_ERASE_CMD       0x40
  #define FLASH_PROGRAM_CMD     0x20
  #define FLASH_BURST_CMD       0x25
  
  #ifndef BUS_CLOCK
    #define BUS_CLOCK    24000000
  #endif
  
  #define FLASH_OK              0
  #define FLASH_ERROR           0xFF
  
  #if BUS_CLOCK > 12800000
    #define FLASH_CLOCK (unsigned char)((BUS_CLOCK/1600000) + 0x40)
  #else
    #define FLASH_CLOCK (unsigned char)(BUS_CLOCK/200000)
  #endif
  
  /* Macros to call the function using the different features */
  #define Flash_Erase(Address) \
          Flash_Cmd((unsigned int)Address, (unsigned int)1, (unsigned char*) 0, FLASH_ERASE_CMD)
  
  #define Flash_Program(Address, Data) \
          Flash_Cmd((unsigned int)Address, (unsigned int)1, (unsigned char*)&Data, FLASH_PROGRAM_CMD)
  
  #define Flash_Burst(Address, Size, DataPtr) \
          Flash_Cmd((unsigned int)Address, (unsigned int)Size, (unsigned char*)DataPtr, FLASH_BURST_CMD)
/*****************************************************************************************************
* Declaration of project wide FUNCTIONS
*****************************************************************************************************/
  #pragma CODE_SEG FLASH_ROUTINES
  unsigned char Flash_Cmd(unsigned int FlashAddress, unsigned char FlashDataCounter, unsigned char* pFlashDataPtr, unsigned char FlashCommand);
  
  #pragma CODE_SEG DEFAULT
  void FlashInit(void);
#endif /* __S08_FLASH__ */