#ifndef __CF_FLASH__
#define __CF_FLASH__


  
#define FLASH_MASS_ERASE_CMD  0x41
#define FLASH_ERASE_CMD       0x40
#define FLASH_PROGRAM_CMD     0x20
#define FLASH_BURST_CMD       0x25
  
#if (BUS_CLOCK) > 12800000 /* 12.8 MHz */
    #define FLASH_CLOCK (UINT8)(( (BUS_CLOCK/1600000) -1) | 0x40)
#else
    #define FLASH_CLOCK (unsigned char)( (BUS_CLOCK/200000) -1)//<200KHz
#endif
  
/* Macros to call the function using the different features */
#define Flash_Erase(Address) \
          Flash_Cmd((UINT32)Address, (UINT16)1, (UINT32*)0x20800/*CUSTOM_ROM_SYMBOLS*/, FLASH_ERASE_CMD)
  
#define Flash_Program(Address, Data) \
          Flash_Cmd((UINT32)Address, (UINT16)1, (UINT32*)&Data, FLASH_PROGRAM_CMD)
  
#define Flash_Burst(Address, Size, DataPtr) \
          Flash_Cmd((UINT32)Address, (UINT16)Size, (UINT32*)DataPtr, FLASH_BURST_CMD)
          
/*FSL: prototypes*/
void 
FlashInit(void);

UINT8 /*far*/ 
Flash_Cmd(UINT32 FlashAddress, 
          UINT16 FlashDataCounter, 
          UINT32 *pFlashDataPtr, 
          UINT8 FlashCommand);

#endif







#define FSTAT_FACCERR     F2STAT_FACCERR
#define FCDIV             F2CDIV  
#define FPROT             F2PROT  
#define FSTAT_FPVIOL      F2STAT_FPVIOL 
#define FCMD              F2CMD
#define FSTAT_FCBEF       F2STAT_FCBEF  
#define FSTAT_FCCF        F2STAT_FCCF 
#define FCDIV_FDIVLD_MASK F2CDIV_FDIVLD_MASK 
#define FSTAT             F2STAT
#define FSTAT_FCBEF_MASK  F2STAT_FCBEF_MASK
#define FSTAT_FCCF_MASK   F2STAT_FCCF_MASK