#**************************************************************************/
#* FILE NAME: mpc5500_xcptn.c              COPYRIGHT (c) Freescale 2007   */
#*                                                All Rights Reserved     */
#* DESCRIPTION:                                                           */
#* This software is part of the MPC5516 Interrupt Controller Validation.  */
#* This test only uses the Z1 core on MPC5516.							  */
#* This is the branch table for the IVOR vectors. The "IVORnTable"        */
#* label is aligned with the IVPR. The IVOR4 handler must be offset from  */
#* this by 0x40.                                                          */
#* Syntax specifically written for Diab compiler						  */                                                                        */
#*========================================================================*/
#* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE               */
#* ---   -----------    ----------    ---------------------               */
#* 0.1	  R. Moran		 23/Feb/07    Initial Version					  */
#**************************************************************************/
	.globl   IVORnTable

  .section .xcptn,va         # The "v" indicates VLE code
	.vle
	
  # Position of IVPR    
	IVORnTable:
     
	.offset 0x0
	e_b dummy
	
	.offset 0x10
	e_b dummy
	
	.offset 0x20
	e_b dummy
	
	.offset 0x30
	e_b dummy

	.offset 0x60
	e_b dummy

	# IVOR4 IRQ59 Vector Handler - Offset of 0x800 + (59 << 2 bits), i.e. Offset = 0x940
  .offset 0x08EC
  e_b INTC_IRQ59_ISR 
  
  dummy:
	nop
	e_b dummy


