/****************************************************************************************************/
/**
\file       main.c
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date		    August 2009      
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  	*/
/* CUSTOMER retains the final decision relative to the total design and functionality of the end 	*/
/* product.                                                                                      	*/
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include <hidef.h>      /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */

/** HIL includes */
#include "Menu.h"

/** HAL includes */
#include "IRTC.h"
#include "LCD.h"
#include "KBI.h"
#include "MTIM.h"
#include "GPIO.h"
#include "ICS.h"



/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/
void vfnCPU_Init (void);
void vfnIdle (void);
void vfnDetectMenu (void);
void vfnConfigClock (void);
void vfnRefreshClock (void);

/*****************************************************************************************************
* Definition of module wide MACROs / #DEFINE-CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Declaration of module wide TYPEs - NOT for use in other modules
*****************************************************************************************************/
/** Main State enumeration*/
typedef enum
{
	Idle,
	DetectMenu,
	ConfigClock,
	RefreshClock 
}Clock_States;

/*****************************************************************************************************
* Definition of module wide VARIABLEs - NOT for use in other modules
*****************************************************************************************************/
/** Main State Machine structure */
sSM  sClockSM;

/*****************************************************************************************************
* Definition of module wide (CONST-) CONSTANTs - NOT for use in other modules
*****************************************************************************************************/
/*****************************************************************************************************/
/** Function pointer arrays */
void (*const ClockStates[ ])(void) = 
{
	vfnIdle,
	vfnDetectMenu,
	vfnConfigClock,
	vfnRefreshClock
};


/*****************************************************************************************************
* Code of project wide FUNCTIONS
*****************************************************************************************************/
/**
* \brief    Main function. Initializes all the peripherals and calls the current state from the Main State Machine
* \param    void							
* \return   void
*/
void main(void) 
{
	/** Peripheral initialization */
	vfnCPU_Init();
  
  EnableInterrupts; 

	for(;;) 
	{
		__RESET_WATCHDOG(); 
		ClockStates[sClockSM.NextState]();
	} 
  
}
/****************************************************************************************************/
/*****************************************************************************************************
* StateMachine
*****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief vfnIdle
* \brief  Idle State, if a key has been detected DetectMenu is called like the next state. In case of a IRTC event has 
			 occur the RefreshClock states is the next state at the Main State Machine
* \param   void																			
* \return   void
*/
void vfnIdle (void)
{
  sClockSM.PrevState =  sClockSM.ActualState;   
  sClockSM.ActualState = sClockSM.NextState;

   if (KEY)
   {
		KEY_CLEAR;
		_LCD_PROGRAM_ON;
		sClockSM.NextState = DetectMenu;
   }

	if (IRTC && END_MENU)
	{
		_LCD_TIME_ON;	
		IRTC_CLEAR;
		sClockSM.NextState = RefreshClock;
	}
}
/****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief 	vfnDetectMenu   
* \brief 	Menu handler, displays values and stores the content in IRTC structure     
* \param   void  
* \return   void
*/
void vfnDetectMenu (void)
{
volatile UINT8 u8Key = 0;

  sClockSM.PrevState =  sClockSM.ActualState;   
  sClockSM.ActualState = sClockSM.NextState;
    
    /** Read what key was pressed*/
	u8Key = u8fnGetKey( );

	if ( FALSE_KEY)
	{
		/** It wasn't a valid key, do nothing and go to Idle */
		FALSE_KEY_CLEAR;
		sClockSM.NextState = Idle;
	} 
	else
	{
		/** If is a valid key go to the Menu Handler function*/
		END_MENU_CLEAR;
		_LCD_PROGRAM_OFF;
		vfnClockMenu(u8Key);

	   /** The menu has been finished then go to the ConfigClock state */
		if (END_MENU) 
		{
			sClockSM.NextState = ConfigClock;	
		} 
		/** The menus hasn't been finished, then go to Idle state*/
		else
		{
			sClockSM.NextState = Idle;
		}
	}
}
/****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief		vfnRefreshClock   
* \brief    Refresh the TIME displayed at the LCD    
* \param   void 											
* \return   void
*/
void vfnRefreshClock (void)
{
	sClockSM.PrevState =  sClockSM.ActualState;   
	sClockSM.ActualState = sClockSM.NextState;
    vfnRefreshLCD( );
	sClockSM.NextState = Idle;
 
}
/****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief		vfnConfigClock   
* \brief		Change clock configuration    
* \param   void  
* \return   void
*/
void vfnConfigClock (void)
{
  sClockSM.PrevState =  sClockSM.ActualState;   
  sClockSM.ActualState = sClockSM.NextState;
  
  vfnConfigIRTC();
  sClockSM.NextState = RefreshClock;

}
/****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief  vfnCPU_Init
* \param  void  
* \return void
* \todo     
*/
void vfnCPU_Init (void)
{
  vfnIRTC_Init ();
	vfnICS_FEI();
	vfnLCD_Init();
	vfnGPIO_Init();
  vfnKBI_Init();
  vfnMTIM_Init ();
  
  	/** Initialize State Machine with Idle Status*/
	sClockSM.PrevState = Idle;
	sClockSM.ActualState = Idle;
	sClockSM.NextState = RefreshClock;
   
	//END_MENU_EVENT;

	_LCD_FREESCALE_ON;

	

	

}
/****************************************************************************************************/

