/****************************************************************************************************/
/**
\file         Clock.c
\author     Alejandra Guzmn Castellanos
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date			August 2009      
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  	*/
/* CUSTOMER retains the final decision relative to the total design and functionality of the end 	*/
/* product.                                                                                      	*/
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "Clock.h"

/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/
void vfnConfigCountDown (void);
void vfnConfigTime (void);
void vfnConfigAlarm (void);
void vfnConfigDaylight (void);
/*****************************************************************************************************
* Definition of module wide MACROs / #DEFINE-CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

#define ALARM_YEAR				IRTC_ALM_YRMON_bin
#define ALARM_DAYS				IRTC_ALM_DAYS_bin
#define ALARM_HOURMIN		IRTC_ALM_HM_bin
#define ALARM_SECONDS		IRTC_ALM_SEC_bin

#define DAYLIGHT_HOUR		IRTC_DST_HOUR_bin
#define DAYLIGHT_MONTH	IRTC_DST_MNTH_bin
#define DAYLIGHT_DAY			IRTC_DST_DAY_bin

#define COUNTDOWN			IRTC_COUNT_DN_bin
/*****************************************************************************************************
* Declaration of module wide TYPEs - NOT for use in other modules
*****************************************************************************************************/
  typedef enum
  {
	year,
	one,
	two,
	three,
	Hours,
	five,
	Minutes,
	seven,
	Seconds
  }LCD_place_enum;
 
/*****************************************************************************************************
* Definition of module wide VARIABLEs - NOT for use in other modules
*****************************************************************************************************/
extern UINT8 gu8LCD_CharPosition;
extern ClockStatus  IRTCStatus;
extern volatile UINT32 gu32Menu;
extern volatile UINT8 gu8StatusFlag;
/*****************************************************************************************************
* Definition of module wide (CONST-) CONSTANTs - NOT for use in other modules
*****************************************************************************************************/
void (*const ConfigurationStates[])(void) = 
{
	vfnConfigCountDown,
	vfnConfigTime,
	vfnConfigAlarm,
	vfnConfigDaylight
};

/*****************************************************************************************************
* Code of project wide FUNCTIONS
*****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief    
* \param   void  
* \return  void
*/
 void vfnRefreshLCD (void)
 {
  UINT8 u8SecondsTemp;
 
 	vfnClearAlphanumeric ();
	if (IRTC_CNTDN)
	{
		if (IRTC_MIN)
		{
			IRTCStatus.u8CntDown --;	
			IRTC_MIN_CLEAR;	
		}
		_LCD_COL2_OFF;
		_LCD_COL3_ON;
		u8SecondsTemp = (UINT8)(60 - IRTC_SECONDS_bin_SECONDS);
		vfnLCD_WriteDecimal (IRTCStatus.u8CntDown, Minutes);	
		vfnLCD_WriteDecimal (u8SecondsTemp , Seconds);	
	}
	else
	{
		_LCD_COL2_ON;
		_LCD_COL3_ON;
		vfnUnprotectRTC ( );
		vfnLCD_WriteDecimal ( IRTC_HOURMIN_bin_HOURS , Hours);	
		vfnLCD_WriteDecimal (IRTC_HOURMIN_bin_MINUTES , Minutes);	
		vfnLCD_WriteDecimal (IRTC_SECONDS_bin_SECONDS , Seconds);	
	}

 }
/****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief    
* \author   
* \param   void  
* \return   void
* \todo     
*/
void vfnConfigIRTC (void)
{
	ConfigurationStates[gu32Menu]();
}

/****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief    
* \author   
* \param   void  
* \return   void
* \todo     
*/
void vfnConfigCountDown (void)
{
	vfnUnprotectRTC ();
  COUNTDOWN = (UINT16)(IRTCStatus.u8CntDown);
	PROTECT_IRTC();

	IRTC_CNTDN_EVENT;
}
/****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief    
* \author   
* \param   void  
* \return   void
* \todo     
*/
void vfnConfigTime (void)
{
	vfnIRTC_Time_SetYear (IRTCStatus.u16Years);
	vfnIRTC_Time_SetMonth (IRTCStatus.u8Months);
	vfnIRTC_Time_SetDay (IRTCStatus.u8Days);
	vfnIRTC_Time_SetHour (IRTCStatus.u8Hours);
	vfnIRTC_Time_SetMinute (IRTCStatus.u8Minutes);
	vfnIRTC_Time_SetSeconds (0);

}
/****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief    
* \author   
* \param   void  
* \return   void
* \todo     
*/
void vfnConfigAlarm (void)
{
	vfnUnprotectRTC ();

	ALARM_YEAR = (UINT16) ( SetYear(IRTCStatus.u16Years) + IRTCStatus.u8Months);
	ALARM_DAYS = IRTCStatus.u8Days;
	ALARM_HOURMIN = (UINT16)((IRTCStatus.u8Hours<<8) + IRTCStatus.u8Minutes);
	ALARM_SECONDS = 0;

	PROTECT_IRTC();
}
/****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief    
* \author   
* \param   void  
* \return   void
* \todo     
*/
void vfnConfigDaylight (void)
{
	vfnUnprotectRTC ();

	DAYLIGHT_HOUR = (UINT16) ( (IRTCStatus.u8Hours << 8) + IRTCStatus.u8DEndHours);
	DAYLIGHT_MONTH = (UINT16) ( (IRTCStatus.u8Months << 8) + IRTCStatus.u8DEndMonths);
	DAYLIGHT_DAY = (UINT16) ( (IRTCStatus.u8Days << 8) + IRTCStatus.u8DEndDays);

	PROTECT_IRTC();
}
/****************************************************************************************************/




