/****************************************************************************************************/
/**
\file       IRTC.h
\author     Alejandra Guzmn Castellanos
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date		    August 2009      
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  	*/
/* CUSTOMER retains the final decision relative to the total design and functionality of the end 	*/
/* product.                                                                                      	*/
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/

/*****************************************************************************************************
* Module definition against multiple inclusion
*****************************************************************************************************/
#ifndef __APP_IRTC_H
#define __APP_IRTCI_H

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "FslTypes.h"
#include "GPIO.h"
/*****************************************************************************************************
* Declaration of project wide TYPES
*****************************************************************************************************/

#define _SUNDAY 		0
#define _MONDAY			1
#define _TUESDAY		2
#define _WEDNESDAY	3
#define _THURSDAY		4
#define _FRIDAY			5
#define _SATURDAY		6

#define _DECEMBER 	12
#define	_JANUARY		1


/*****************************************************************************************************
* Definition of project wide VARIABLES
*****************************************************************************************************/
extern UINT8 gu8IRTCStatusFlag;

/*****************************************************************************************************
* Definition of project wide MACROS / #DEFINE-CONSTANTS 
*****************************************************************************************************/
#define		_YEAR		  2009
#define		_MONTH	  _DECEMBER		
#define		_DAY		  _WEDNESDAY
#define		_HOUR		  12
#define 	_MINUTES	0
#define		_SECONDS  0	

/** ------------------------------------------------------------------------------       RTC CONTROL REGISTER       ------------------------------------------------------------------------------*/
#define		_RTC_CLCK_OUTPUT  0		/**0- disable RTC clock oscillator like ouput  1 - enable RTC clock oscillator like output*/
#define 	_RTC_SELECT_CLCK  0		/** 0 - no clock  1 - 1Hz clock  2 - buffer oscillator */	
#define 	_RTC_TAMP_FTR     0		/** 0 - no filtering   1-15 # of oscillator clocks for tamper detection */
#define 	_RTC_SW_RESET     1		/** 1 - clear contents of alarm, interrupts, status and enable registers  0 - no software reset*/

#define		_RTC_BCD					0		/** 1 - BCD format  0 - binary format NOTE only for register read Hour, Minutes, Seconds and Day*/
#define		_RTC_DAYLIGHT     0		/** 0 - Enable daylight saving 	1 - Disable daylight saving */
#define 	_RTC_ALARM_MATCH  3		/** 0 - Alarm when Seconds, Minutes and Hours matched
										  		          1 - Alarm when Seconds, Minutes, Hours and Days matched
													          2 - Alarm when Seconds, Minutes, Hours, Days and Months matched
										          			3 - Alarm when Seconds, Minutes, Hours, Days, Months and Year (offset) matched */

#define IRTC_CTRL_INIT	IRTC_CTRL = ( (_RTC_CLCK_OUTPUT<<15) + (_RTC_SELECT_CLCK<<13) + (_RTC_TAMP_FTR<<9) + (_RTC_SW_RESET<<8) + (_RTC_BCD<<7) + (_RTC_DAYLIGHT<<6) + (_RTC_ALARM_MATCH<<2))
/** ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/

#define IRTC_EVENT	      EVENT(gu8IRTCStatusFlag, 0)		
#define IRTC				      COMPARE(gu8IRTCStatusFlag, 0)					
#define IRTC_CLEAR	      CLEAR(gu8IRTCStatusFlag,0)

#define	IRTC_MIN_EVENT		EVENT(gu8IRTCStatusFlag, 6)
#define IRTC_MIN				  COMPARE(gu8IRTCStatusFlag, 6)
#define IRTC_MIN_CLEAR		CLEAR(gu8IRTCStatusFlag, 6)

#define IRTC_CNTDN_EVENT	EVENT(gu8IRTCStatusFlag, 7)
#define IRTC_CNTDN		    COMPARE(gu8IRTCStatusFlag, 7)
#define	IRTC_CNTDN_CLEAR	CLEAR(gu8IRTCStatusFlag, 7)

#define IRTC_PROTECTED		IRTC_STATUS_WPE

#define UNPROTECT_IRTC()	IRTC_CTRL_WE = 0b00;\
									        IRTC_CTRL_WE = 0b01;\
									        IRTC_CTRL_WE = 0b11;\
								         	IRTC_CTRL_WE = 0b10	  

#define PROTECT_IRTC()		IRTC_CTRL_WE = 0b10
					 										 
#define	_BASEYEAR	2112
#define	SetYear(Year)		(UINT8)(Year - _BASEYEAR)
#define	GetYear(offset)	(UINT16)(_BASEYEAR + (INT8)(offset))
	
#define vfnIRTC_Time_SetYear(Year)		vfnUnprotectRTC();\
										                  IRTC_YEARMON_bin_YEAR = SetYear(Year);\
										                  PROTECT_IRTC()

#define vfnIRTC_Time_SetMonth(Month)	vfnUnprotectRTC();\
										                  IRTC_YEARMON_bin_MONTH = Month;\
										                  PROTECT_IRTC()

#define vfnIRTC_Time_SetDay(Day)		  vfnUnprotectRTC();\
										                  IRTC_DAYS_bin_DAYS = Day;\
										                  PROTECT_IRTC()

#define vfnIRTC_Time_SetHour(Hour)		vfnUnprotectRTC();\
										                  IRTC_HOURMIN_bin_HOURS = Hour;\
										                  PROTECT_IRTC()

#define vfnIRTC_Time_SetMinute(Minute) vfnUnprotectRTC();\
										                  IRTC_HOURMIN_bin_MINUTES = Minute;\
									                  	PROTECT_IRTC()

#define vfnIRTC_Time_SetSeconds(Second)	vfnUnprotectRTC();\
									                    IRTC_SECONDS_bin_SECONDS = Second;\
										                  PROTECT_IRTC()

																		

/*****************************************************************************************************
* Declaration of project wide FUNCTIONS
*****************************************************************************************************/
void vfnIRTC_Init (void);
void vfnUnprotectRTC (void);

UINT16 u16IRTC_Time_GetYear(void);
UINT8 u8IRTC_Time_GetMonth (void);
UINT8 u8IRTC_Time_GetDay  (void);
UINT8 u8IRTC_Time_GetHour (void);
UINT8 u8IRTC_Time_GetMinute (void);
UINT8 u8IRTC_GetCountDown (void);
 
/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

#endif /* __APP_IRTC_H */