#ifndef __Definitions__
  #define __Definitions__

/** Macros definitions for flag */
#define EVENT(variable, bit)		variable |= (1<<bit)
#define COMPARE(variable, bit)	variable & (1<<bit)
#define CLEAR(variable, bit)		variable &=  ~((UINT32)(1<<bit))

  /* Typedefs */
  /* Standard Types */
  typedef unsigned char   UINT8;  		/*unsigned 8 bit definition */
  typedef unsigned short  UINT16; 		/*unsigned 16 bit definition*/
  typedef unsigned long   UINT32; 		/*unsigned 32 bit definition*/
  typedef signed char     INT8;   		/*signed 8 bit definition */
  typedef short           INT16;  		/*signed 16 bit definition*/
  typedef long int        INT32;  		/*signed 32 bit definition*/

 /* State Machine */
  typedef struct
  {
    UINT8 ActualState;
    UINT8 PrevState;
    UINT8 NextState;
    UINT8 ErrorState;
  }sSM;

typedef struct 
{
  UINT16	u16Years;
  UINT8	u8Months;
  UINT8	u8Days;
  UINT8 	u8Hours;
  UINT8	u8DEndMonths;
  UINT8	u8DEndDays;
  UINT8 	u8DEndHours;
  UINT8 	u8Minutes;
  UINT8 	u8CntDown;
  UINT16 u16Interrupts;	
}ClockStatus;


#endif /* __Definitions__ */