/******************************************************************************		
*                                                                                   	
*       Copyright (C) 2008 Freescale Semiconductor, Inc.                            	
*       All Rights Reserved								              				
*														              					
* Filename:       SCI_DRV.H               											
*														              					
* Description:	  SCI Header files       	    	
*																						
* Notes:        																		
*  ***********************************************************************  			
*  *  THIS CODE IS ONLY INTENDED AS AN EXAMPLE OF CODE FOR THE           *  	 		
*  *  METROWERKS COMPILER AND HAS ONLY BEEN GIVEN A MIMIMUM              *  	 		
*  *  LEVEL OF TEST. IT IS PROVIDED 'AS SEEN' WITH NO GUARANTEES         *  	 		
*  *  AND NO PROMISE OF SUPPORT.                                         *  	 		
*  ***********************************************************************  	 		
*																						
* Freescale reserves the right to make changes without further notice to any			
* product herein to improve reliability, function, or design. Freescale does	 		
* not assume any  liability arising  out  of the  application or use of any 	 		
* product,  circuit, or software described herein;  neither  does it convey 	 		
* any license under its patent rights  nor the  rights of others.  Freescale	 		
* products are not designed, intended,  or authorized for use as components 	 		
* in  systems  intended  for  surgical  implant  into  the  body, or  other 	 		
* applications intended to support life, or  for any  other application  in 	 		
* which the failure of the Freescale product  could create a situation where	 		
* personal injury or death may occur. Should Buyer purchase or use Freescale	 		
* products for any such intended  or unauthorized  application, Buyer shall 	 		
* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,	 		
* affiliates,  and distributors harmless against all claims costs, damages, 	  		
* and expenses, and reasonable  attorney  fees arising  out of, directly or 	 		
* indirectly,  any claim of personal injury  or death  associated with such 	 		
* unintended or unauthorized use, even if such claim alleges that  Freescale	 		
* was negligent regarding the  design  or manufacture of the part. Freescale	 		
* and the Freescale logo* are registered trademarks of Freescale Ltd.       	 		
******************************************************************************/		
/******************************************************************************/
#ifndef SCI_DRV_H        /* prevent duplicated includes*/
#define SCI_DRV_H

/* 
   required for ColdFire -> Stores data to reduce data size instead of improving 
                            execution performance.
   pop -> see end of this file
*/
#pragma pack(push,1)

/************************* Project Include Files *****************************/

/************************* Variables *****************************/
typedef union 
{
  unsigned short Word;
  struct 
    {
    unsigned short SBR         :13;       /* Baud Rate Modulo Divisor */
    unsigned short             :1; 
    unsigned short RXEDGIE     :1;        /* RxD Input Active Edge Interrupt Enable (for RXEDGIF) */
    unsigned short LBKDIE      :1;        /* LIN Break Detect Interrupt Enable (for LBKDIF) */
    } Bits;
}SCI_BDRegType;
      
typedef union {
  unsigned char Byte;
  struct {
    unsigned char PT          :1;                                       /* Parity Type */
    unsigned char PE          :1;                                       /* Parity Enable */
    unsigned char ILT         :1;                                       /* Idle Line Type Select */
    unsigned char WAKE        :1;                                       /* Receiver Wakeup Method Select */
    unsigned char M           :1;                                       /* 9-Bit or 8-Bit Mode Select */
    unsigned char RSRC        :1;                                       /* Receiver Source Select */
    unsigned char SCISWAI     :1;                                       /* SCI Stops in Wait Mode */
    unsigned char LOOPS       :1;                                       /* Loop Mode Select */
  } Bits;
} SCI_C1RegType;

typedef union {
  unsigned char Byte;
  struct {
    unsigned char SBK         :1;                                       /* Send Break */
    unsigned char RWU         :1;                                       /* Receiver Wakeup Control */
    unsigned char RE          :1;                                       /* Receiver Enable */
    unsigned char TE          :1;                                       /* Transmitter Enable */
    unsigned char ILIE        :1;                                       /* Idle Line Interrupt Enable (for IDLE) */
    unsigned char RIE         :1;                                       /* Receiver Interrupt Enable (for RDRF) */
    unsigned char TCIE        :1;                                       /* Transmission Complete Interrupt Enable (for TC) */
    unsigned char TIE         :1;                                       /* Transmit Interrupt Enable (for TDRE) */
  } Bits;
} SCI_C2RegType;

typedef union {
  unsigned char Byte;
  struct {
    unsigned char PF          :1;                                       /* Parity Error Flag */
    unsigned char FE          :1;                                       /* Framing Error Flag */
    unsigned char NF          :1;                                       /* Noise Flag */
    unsigned char OR          :1;                                       /* Receiver Overrun Flag */
    unsigned char IDLE        :1;                                       /* Idle Line Flag */
    unsigned char RDRF        :1;                                       /* Receive Data Register Full Flag */
    unsigned char TC          :1;                                       /* Transmission Complete Flag */
    unsigned char TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI_S1RegType;

typedef union {
  unsigned char Byte;
  struct {
    unsigned char RAF         :1;                                       /* Receiver Active Flag */
    unsigned char LBKDE       :1;                                       /* LIN Break Detection Enable */
    unsigned char BRK13       :1;                                       /* Break Character Generation Length */
    unsigned char RWUID       :1;                                       /* Receive Wake Up Idle Detect */
    unsigned char RXINV       :1;                                       /* Receive Data Inversion */
    unsigned char             :1; 
    unsigned char RXEDGIF     :1;                                       /* RxD Pin Active Edge Interrupt Flag */
    unsigned char LBKDIF      :1;                                       /* LIN Break Detect Interrupt Flag */
  } Bits;
} SCI_S2RegType;

typedef union {
  unsigned char Byte;
  struct {
    unsigned char PEIE        :1;                                       /* Parity Error Interrupt Enable */
    unsigned char FEIE        :1;                                       /* Framing Error Interrupt Enable */
    unsigned char NEIE        :1;                                       /* Noise Error Interrupt Enable */
    unsigned char ORIE        :1;                                       /* Overrun Interrupt Enable */
    unsigned char TXINV       :1;                                       /* Transmit Data Inversion */
    unsigned char TXDIR       :1;                                       /* TxD Pin Direction in Single-Wire Mode */
    unsigned char T8          :1;                                       /* Ninth Data Bit for Transmitter */
    unsigned char R8          :1;                                       /* Ninth Data Bit for Receiver */
  } Bits;
} SCI_C3RegType;

typedef union {
  unsigned char Byte;
  struct {
    unsigned char R0_T0       :1;                                       /* Receive/Transmit Data Bit 0 */
    unsigned char R1_T1       :1;                                       /* Receive/Transmit Data Bit 1 */
    unsigned char R2_T2       :1;                                       /* Receive/Transmit Data Bit 2 */
    unsigned char R3_T3       :1;                                       /* Receive/Transmit Data Bit 3 */
    unsigned char R4_T4       :1;                                       /* Receive/Transmit Data Bit 4 */
    unsigned char R5_T5       :1;                                       /* Receive/Transmit Data Bit 5 */
    unsigned char R6_T6       :1;                                       /* Receive/Transmit Data Bit 6 */
    unsigned char R7_T7       :1;                                       /* Receive/Transmit Data Bit 7 */
  } Bits;
} SCI_DRegType;

typedef struct				/*sci datastructure	*/
  {
  SCI_BDRegType	SCIBD;	/*sci baud rate register */
  SCI_C1RegType SCICR1;	/*sci control register 1 */
  SCI_C2RegType	SCICR2;	/*sci control register 2 */
  SCI_S1RegType	SCISR1;	/*sci status register 1	*/
  SCI_S2RegType	SCISR2;	/*sci status register 2	*/
  SCI_C3RegType	SCICR3;	/*sci control register 3 */
  SCI_DRegType  SCIDR;	/*sci data register low	*/   
  }tSCI;

  
extern tSCI *TerminalPointer; /* Global Variable indicating which SCI is in use */


/************************* #Defines ******************************************/
#define SCI1 0xFFFF82C0
#define SCI2 0xFFFF82E0
#define SCI3 0xFFFF8300

 
/************************* Macros ********************************************/

#define _CR PutChar(\r)
#define _LF PutChar(\n)
#define NEW_LINE() DisplayString("\r\n")
#define CLEAR_DISPLAY() PutChar(0x0C)
#define LF NEW_LINE							


/************************* Prototypes ****************************************/

void SCI_Config(tSCI *, unsigned short);
unsigned char convert2ASCII(unsigned char);
unsigned char convertFrmASCII(unsigned char);
void DisplayByte(unsigned char); 
void DisplayWord(unsigned short); 
void DisplayString (unsigned char*);
void PutChar (unsigned char);
void DisplayLong(unsigned long, unsigned char); 
void DisplayInt(unsigned short, unsigned char);
unsigned char GetChar(void);
unsigned short GetWord(void);

#pragma pack(pop)


#endif /* SCI_DRV_H */