/******************************************************************************		
*                                                                                   	
*       Copyright (C) 2008 Freescale Semiconductor, Inc.                            	
*       All Rights Reserved								              				
*														              					
* Filename:       sciu_drv.c               											
*														              					
* Description:	  sci driver source file        	    	
*																						
* Notes:        																		
*  ***********************************************************************  			
*  *  THIS CODE IS ONLY INTENDED AS AN EXAMPLE OF CODE FOR THE           *  	 		
*  *  METROWERKS COMPILER AND HAS ONLY BEEN GIVEN A MIMIMUM              *  	 		
*  *  LEVEL OF TEST. IT IS PROVIDED 'AS SEEN' WITH NO GUARANTEES         *  	 		
*  *  AND NO PROMISE OF SUPPORT.                                         *  	 		
*  ***********************************************************************  	 		
*																						
* Freescale reserves the right to make changes without further notice to any			
* product herein to improve reliability, function, or design. Freescale does	 		
* not assume any  liability arising  out  of the  application or use of any 	 		
* product,  circuit, or software described herein;  neither  does it convey 	 		
* any license under its patent rights  nor the  rights of others.  Freescale	 		
* products are not designed, intended,  or authorized for use as components 	 		
* in  systems  intended  for  surgical  implant  into  the  body, or  other 	 		
* applications intended to support life, or  for any  other application  in 	 		
* which the failure of the Freescale product  could create a situation where	 		
* personal injury or death may occur. Should Buyer purchase or use Freescale	 		
* products for any such intended  or unauthorized  application, Buyer shall 	 		
* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,	 		
* affiliates,  and distributors harmless against all claims costs, damages, 	  		
* and expenses, and reasonable  attorney  fees arising  out of, directly or 	 		
* indirectly,  any claim of personal injury  or death  associated with such 	 		
* unintended or unauthorized use, even if such claim alleges that  Freescale	 		
* was negligent regarding the  design  or manufacture of the part. Freescale	 		
* and the Freescale logo* are registered trademarks of Freescale Ltd.       	 		
******************************************************************************/		

/* include files */

#include "sci_drv.h"

tSCI *TerminalPointer; /* Global Variable indicating which SCI is in use */

/******************************************************************************
Function Name	:	SCI_Config
Engineer		:	r32151
Date			:	05/03/02

Parameters		:	NONE
Returns			:	NONE
Notes			:	Configures SCI
******************************************************************************/
void
SCI_Config(tSCI *sci_ptr, unsigned short prescaler)
{
		/* set baud rate */
	sci_ptr->SCIBD.Word = prescaler;
		/* set control register 1 */
	sci_ptr->SCICR1.Byte = 0x00;
		/* enable transmit */
	sci_ptr->SCICR2.Bits.TE = 1;
		/* enable receive */
	sci_ptr->SCICR2.Bits.RE = 1;

}


/******************************************************************************
Function Name	:	DisplayString
Engineer		:	r58711
Date			:	14/02/02

Parameters		:	textString[]
Returns			:	NONE
Notes			:	Output text string as ASCII to SCI
******************************************************************************/
void DisplayString (unsigned char *textPointer)
{
		/* while not end of string */
	while(*textPointer != 0)
	{	
			/* write the character to the SCI interface */
		PutChar(*textPointer);
			/* increment to point at the next character in the string */
		textPointer++;
	}	
}

/******************************************************************************
Function Name	:	DisplayByte
Engineer		:	r58711
Date			:	14/02/02

Parameters		:	displayByte
Returns			:	NONE
Notes			:	Output variable SCI after conversion to ASCII
******************************************************************************/
void DisplayByte (unsigned char displayByte)
{
	unsigned char upperNibble, lowerNibble;
		/* Split data into nibbles for ASCII conversion */
	upperNibble = (unsigned char)((displayByte & 0xF0)>>4); 
	lowerNibble = (unsigned char)(displayByte & 0x0F);
		/* Pass nibbles to SCI after passing for conversion to ASCII */
	PutChar(convert2ASCII(upperNibble));
	PutChar(convert2ASCII(lowerNibble));
}

/******************************************************************************
Function Name	:	DisplayWord
Engineer		:	r54940
Date			:	24/09/08

Parameters		:	displayWord
Returns			:	NONE
Notes			:	Output variable SCI after conversion to ASCII
******************************************************************************/
void DisplayWord (unsigned short displayWord)
{
	unsigned char Nibble1, Nibble2, Nibble3, Nibble4;
		/* Split data into nibbles for ASCII conversion */
	Nibble4 = (unsigned char)((displayWord & 0xF000)>>12); 
	Nibble3 = (unsigned char)((displayWord & 0x0F00)>>8);
	Nibble2 = (unsigned char)((displayWord & 0x00F0)>>4); 
	Nibble1 = (unsigned char)(displayWord & 0x000F);
		/* Pass nibbles to SCI after passing for conversion to ASCII */
	PutChar(convert2ASCII(Nibble4));
	PutChar(convert2ASCII(Nibble3));
	PutChar(convert2ASCII(Nibble2));
	PutChar(convert2ASCII(Nibble1));
}

/******************************************************************************
Function Name	:	PutChar
Engineer		:	r32151
Date			:	22/01/02

Parameters		:	char to be output to SCI1
Returns			:	NONE
Notes			:	
******************************************************************************/
void PutChar(unsigned char ch) 
{
		/* check SCI transmit data register is empty */
	while(TerminalPointer->SCISR1.Bits.TDRE == 0)
	{
	}	
	TerminalPointer->SCIDR.Byte = ch;	
}

/******************************************************************************
Function Name	:	GetChar
Engineer		:	r32151
Date			:	04/11/02

Parameters		:	char to be output to SCI
Returns			:	NONE
Notes			:	
******************************************************************************/
unsigned char GetChar(void) 
{
		/* check SCI1 receive data register is empty */
	while(TerminalPointer->SCISR1.Bits.RDRF == 0)
	{
	}	
	return(TerminalPointer->SCIDR.Byte);	

}

/******************************************************************************
Function Name	:	GetWord
Engineer      :	r54940
Date          :	24/09/08

Parameters		:	
Returns			  :	NONE
Notes         :	Gets 4 characters from terminal
******************************************************************************/

unsigned short GetWord (void){

  unsigned short Word;
  
  Word = convertFrmASCII(GetChar());
  Word = (Word<<4)|convertFrmASCII(GetChar());
  Word = (Word<<4)|convertFrmASCII(GetChar());
  Word = (Word<<4)|convertFrmASCII(GetChar());
  return(Word);	
}


/******************************************************************************
Function Name	:	convert2ASCII
Engineer		:	r58711
Date			:	15.11.01

Parameters		:	Nibble of binary data (0000 to 1111) (unsigned char)
Returns			:	ASCII code for nibble (unsigned char)
*******************************************************************************/
unsigned char convert2ASCII(unsigned char Nibble)
{	
	/* If nibble is less than 9 (ie. a number) */
	if (Nibble <= 0x09) 
		/* Return the ASCII code for this number */
		return ((unsigned char)(Nibble + 0x30)); 
	else
		/* Return the ASCII code for this letter */
		return ((unsigned char)(Nibble + 0x37)); 
}

/******************************************************************************
Function Name	:	convertFrmASCII
Engineer		:	r54940
Date			:	24.09.08

Parameters	:	ASCII code for nibble (unsigned char)	
Returns			:	Nibble of binary data (0000 to 1111) (unsigned char)
*******************************************************************************/
unsigned char convertFrmASCII(unsigned char ASCII)
{	
	/* If nibble is less than 9 (ie. a number) */
	if (ASCII <= 0x39) 
		/* Return the ASCII code for this number */
		return ((unsigned char)(ASCII - 0x30)); 
	else if (ASCII <= 0x5A)
	/* Return the ASCII code for this CAPITAL Letter */
		return ((unsigned char)(ASCII - 0x37));  
	else
		/* Return the ASCII code for this small letter */
		return ((unsigned char)(ASCII - 0x57)); 
} 
 

/******************************************************************************
Function Name	:	DisplayInt
Engineer		:	r32151
Date			:	04/09/02

Parameters		:	short count value to display
					tU08 field width
Returns			:	NONE
Notes			:	Effectively perforns a number to string conversion and then
					outputs the string.
					if field width = 0 then the short is displayed left justified   
					with leading zeros supressed.
					if field width = 1-5 then lowest n digits are displayed
					with leading zeros.
					This routine does not check that the field size is valid.					
******************************************************************************/
void 
DisplayInt(unsigned short number, unsigned char field ) 
{
	unsigned char buf[6];
	unsigned char i = 5;

	buf[i] = 0;
			/* for upto 10 digits : max value for long = 4294967296 */
			/* using a do while loop to take care of the number = 0 */
	do
	{
				/* convert least significant character of the short into ascii -> string buffer */
		buf[--i] = (unsigned char)((char)(number % 10) + '0');
				/* moves next digit to least significant position */
		number /= 10;
	} while (number != 0); 
				/* if field width is less than number of digits only o/p field width of string */
	if ((field < (5-i)) && (field != 0))
		i = (unsigned char)(5 - field);
				/* if field width is more than number of digits add leading zeros */
	if (field > (5-i))
	{
		while ((5-i) < field)
	    {
				/* add leading zeros */ 
		buf[--i] = '0';
		}
	}
	DisplayString(&buf[i] );	
}
	
/******************************************************************************
Function Name	:	DisplayLong
Engineer		:	r32151
Date			:	04/09/02

Parameters		:	long count value to display
					tU08 field width
Returns			:	NONE
Notes			:	Direct replacement for NumberDisplay().

					Effectively perforns a number to string conversion and then
					outputs the string.
					if field width = 0 then the short is displayed left justified   
					with leading zeros supressed.
					if field width = 1-10 then lowest n digits are displayed
					with leading zeros.
					This routine does not check that the field size is valid.
					
					Due to the 32 bit math routines for handling long values
					code size and execution time is significantly larger that
					for DisplayInt.
******************************************************************************/
void 
DisplayLong(unsigned long number, unsigned char field ) 
{
	unsigned char buf[11];
  unsigned char i = 10;
  unsigned char length = 0;

	buf[i] = 0;
			/* for upto 10 digits : max value for long = 4294967296 */
			/* using a do while loop to take care of the number = 0 */
	do
	{
				/* convert least significant character of the short into ascii -> string buffer */
		buf[--i] = (unsigned char)((char)(number % 10) + '0');
				/* moves next digit to least significant position */
		number /= 10;
	} while (number != 0); 
				/* if field width is less than number of digits only o/p field width of string */
	if ((field < (10-i)) && (field != 0))
		i = (unsigned char)(10 - field);
				/* if field width is more than number of digits add leading zeros */
	if (field > (10-i))
	{
		while ((10-i) < field)
	    {
				/* add leading zeros */ 
		buf[--i] = '0';
		}
	}
	DisplayString(&buf[i] );	
}	
