/********************************************************************************
*                                                                     
*       Copyright (C) 2009 Freescale Semiconductor, Inc.              
*       All Rights Reserved								              
*														              
* Filename:     interrupt.c                
*														              
* Revision:      										              
*														              
* Functions:    Includes interrupt service routines
*         
* Description:  
*
* Notes:        
*
*********************************************************************************/

/*********************************** Includes ***********************************/
#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "sci_drv.h" /* SCI Terminal driver header file */

/*********************************** Macros ************************************/

/*********************************** Defines ***********************************/

/********************************** Constant ***********************************/

/*********************************** Variables *********************************/

/*********************************** Prototype *********************************/

/*********************************** Function **********************************/


/*******************************************************************************
 * Interrupt:       ADC_ISR
 *
 * Description:     ADC interrupt handler
 *
 * Returns:         None
 *
 * Notes:
 *
 *******************************************************************************/
interrupt VectorNumber_Vadc1 void ADC1_ISR (void)
{
    /*if(ADC1SC1A_COCOA){
    //DisplayString("\r\nADC1RA = ");
    //DisplayWord(ADC1RA);
  }
  if(ADC1SC1B_COCOB){
    //DisplayString("\r\nADC1RB = ");
    //DisplayWord(ADC1RB);
  }     */
}

interrupt VectorNumber_Vadc2 void ADC2_ISR (void)
{
     /*if(ADC2SC1A_COCOA){
    //DisplayString("\r\nADC2RA = ");
    //DisplayWord(ADC2RA);
  }
  if(ADC2SC1B_COCOB){
    //DisplayString("\r\nADC2RB = ");
    //DisplayWord(ADC2RB);
  }     */
}

interrupt VectorNumber_Vadc3 void ADC3_ISR (void)
{
     /*if(ADC3SC1A_COCOA){
    //DisplayString("\r\nADC3RA = ");
    //DisplayWord(ADC3RA);
  }
  if(ADC3SC1B_COCOB){
    //DisplayString("\r\nADC3RB = ");
    //DisplayWord(ADC3RB);
  }     */
}

interrupt VectorNumber_Vadc4 void ADC4_ISR (void)
{
  /*if(ADC4SC1A_COCOA){
    //DisplayString("\r\nADC4RA = ");
    //DisplayWord(ADC4RA);
  }
  if(ADC4SC1B_COCOB){
    //DisplayString("\r\nADC4RB = ");
    //DisplayWord(ADC4RB);
  }     */
}       

/*******************************************************************************
 * Interrupt:       PDB_ISR
 *
 * Description:     PDB interrupt handler
 *
 * Returns:         None
 *
 * Notes:
 *
 *******************************************************************************/
interrupt VectorNumber_Vpdb void PDB_ISR (void)
{
  PTAD_PTAD0 ^= 1;
  PDBSCR_IF = 1;
  
  //Clear all COCO flags
  ADC1RA;
  ADC1RB;
  ADC2RA;
  ADC2RB;
  ADC3RA;
  ADC3RB;
  ADC4RA;
  ADC4RB;
}

interrupt VectorNumber_Vpdb_err void PDB_ERR_ISR (void)
{
  PTAD_PTAD1 ^= 1;
  
  if (PDBCH1CR_ERRA){
    PDBCH1CR_ERRA = 1;
    DisplayString("\r\n1A");
  }
  if (PDBCH1CR_ERRB){
    PDBCH1CR_ERRB = 1;
    DisplayString("\r\n1B");
  }
  if (PDBCH2CR_ERRA){ 
    PDBCH2CR_ERRA = 1;
    DisplayString("\r\n2A");
  }
  if (PDBCH2CR_ERRB){
    PDBCH2CR_ERRB = 1;
    DisplayString("\r\n2B");
  }
  if (PDBCH3CR_ERRA){
    PDBCH3CR_ERRA = 1;
    DisplayString("\r\n3A");
  }
  if (PDBCH3CR_ERRB){
    PDBCH3CR_ERRB = 1;
    DisplayString("\r\n3B");
  }
  if (PDBCH4CR_ERRA){
    PDBCH4CR_ERRA = 1;
    DisplayString("\r\n4A");
  }
  if (PDBCH4CR_ERRB){
    PDBCH4CR_ERRB = 1;
    DisplayString("\r\n4B");
  }
}

/*******************************************************************************
 * Interrupt:       DUMMY_ISR
 *
 * Description:     dummy isr handler
 *
 * Returns:         None
 *
 * Notes:
 *
 *******************************************************************************/
void DUMMY_ISR (void)
{
  
}
