/******************************************************************************		
*                                                                                   	
*       Copyright (C) 2009 Freescale Semiconductor, Inc.                            	
*       All Rights Reserved								              				
*														              					
* Filename:       PDB.h               											
*														              					
* Description:	  PDB Header files for MCF51EM256	        	    	   	       						
*																						
* Notes:          
*     																		
******************************************************************************/		

/******************************************************************************/

#ifndef PDB_H        /*prevent duplicated includes*/
#define PDB_H

/* 
   required for ColdFire -> Stores data to reduce data size instead of improving 
                            execution performance.
   pop -> see end of this file
*/
//#pragma pack(push,1)  
#pragma options align=packed

/************************* Project Include Files *****************************/

/************************* Variables *****************************************/

typedef union 
{
  unsigned short Word;
  struct 
    {
    unsigned char ENB         :1;        /* Trigger B Enable */
    unsigned char ENA         :1;        /* Trigger A Enable */
    unsigned char BOS         :2;        /* Trigger B Output Select */
    unsigned char AOS         :2;        /* Trigger A Output Select */
    unsigned short            :8;
    unsigned char ERRB        :1;        /* Sequence Error on Trigger B */
    unsigned char ERRS        :1;        /* Sequence Error on Trigger A */
    } Bits;
}PDB_CHCRRegType;

typedef union 
  {
    unsigned short Word;
    struct 
      {
      unsigned short DELAY         :16;       /* PDB Channel Delay A Register */
      } Bits;
}PDB_DELARegType;

typedef union 
  {
    unsigned short Word;
    struct 
      {
      unsigned short DELAY         :16;       /* PDB Channel Delay B Register */
      } Bits;
}PDB_DELBRegType;

typedef union 
  {
    unsigned short Word;
    struct 
      {
      unsigned short               :16;       /* Reserved Registers */
      } Bits;
}PDB_ReservedRegType;


typedef struct				/*PDB Channel datastructure	*/
  {
  PDB_CHCRRegType	PDBCHCR;	/*PDB Channel Control Register */
  PDB_DELARegType	PDBDELA;	/*PDB Channel Delay A Register */
  PDB_DELARegType	PDBDELB;	/*PDB Channel Delay B Register */
  PDB_ReservedRegType;      /* Reserved Registers */
  }tPDB;

//#pragma pack(pop)
#pragma options align=reset


extern tPDB *CHPointer;  /* Global Variable indicating which PDB Channel is addresses */

  
/************************* #Defines ******************************************/

// PDBSCR
#define PRESCALER_1       0x0000
#define PRESCALER_2       0x2000
#define PRESCALER_4       0x4000
#define PRESCALER_8       0x6000
#define PRESCALER_16      0x8000
#define PRESCALER_32      0xA000
#define PRESCALER_64      0xC000
#define PRESCALER_128     0xE000

#define IF_CLR            0x0000
#define IF_SET            0x0080

#define CONT_ONE          0x0000
#define CONT_CONT         0x0040

#define SW_TRIG           0x0020

#define TRIGSEL_COMP1     0x0000
#define TRIGSEL_COMP2     0x0004
#define TRIGSEL_EXT       0x0010
#define TRIGSEL_SW        0x001C

#define IE_DISABLED       0x0000
#define IE_ENABLED        0x0002

#define EN_DISABLED       0x0000
#define EN_ENABLED        0x0001

// PDBCHCR
#define AOS_BYPASSED      0x0000
#define AOS_A             0x0010

#define BOS_BYPASSED      0x0000
#define BOS_B             0x0004

#define ENA_DISABLED       0x0000
#define ENA_ENABLED        0x0002

#define ENB_DISABLED       0x0000
#define ENB_ENABLED        0x0001

/************************* #Defines ******************************************/
#define PDBCH1 0xFFFFE008
#define PDBCH2 0xFFFFE010
#define PDBCH3 0xFFFFE018
#define PDBCH4 0xFFFFE020

/************************* Macros ********************************************/

/************************* Prototypes ****************************************/
void PDB_Init(unsigned short SCR, unsigned short MOD, unsigned short IDELAY);

#endif /* ADC16_H */