/******************************************************************************		
*                                                                                   	
*       Copyright (C) 2009 Freescale Semiconductor, Inc.                            	
*       All Rights Reserved								              				
*														              					
* Filename:       PDB.c               											
*														              					
* Description:	  PDB Driver file for MCF51EM256	        	    	  	       						
*																						
* Notes:        																		
******************************************************************************/		

/* include files */
#include "MCF51EM256.H" /* include peripheral declarations */
#include "PDB.h"    

/******************************************************************************
Function Name	:	PDB_Init
Engineer      :	r54940
Date          :	11/09/09

Parameters		:	
Returns			  :	NONE
Notes         : Initialises PDB
******************************************************************************/
void PDBInit(unsigned short SCR, unsigned short MOD, unsigned short IDELAY)
{

  PDBSCR = SCR;
  PDBMOD = MOD;
  PDBIDELAY = IDELAY;
  
  PDBCH1DELA = 0x0100;
  PDBCH1DELB = 0x04A0;
  PDBCH1CR = (AOS_A|BOS_B|ENA_ENABLED|ENB_ENABLED);
  
  PDBCH2DELA = 0x0100;
  PDBCH2DELB = 0x04E0;
  PDBCH2CR = (AOS_A|BOS_B|ENA_ENABLED|ENB_ENABLED);
  
  PDBCH3DELA = 0x0100;
  PDBCH3DELB = 0x0450;
  PDBCH3CR = (AOS_A|BOS_B|ENA_ENABLED|ENB_ENABLED);
  
  PDBCH4DELB = 0x0400;
  PDBCH4CR = (AOS_A|BOS_B|ENA_DISABLED|ENB_ENABLED);
  
  PDBSCR_EN = 1;

}
