/******************************************************************************		
*                                                                                   	
*       Copyright (C) 2008 Freescale Semiconductor, Inc.                            	
*       All Rights Reserved								              				
*														              					
* Filename:       ICS.c               											
*														              					
* Description:	  ICS Driver files for MCF51EM256	        	    	  	       						
*																						
* Notes:        																		
******************************************************************************/		

/* include files */
#include "MCF51EM256.H" /* include peripheral declarations */
#include "ICS.h"      

/******************************************************************************
Function Name	:	ICS_Config
Engineer      :	r57118, updated by S McLaughlin
Date          :	22/06/06, updated 11/1/07

Parameters		:	+CTL1      - initialization value for the ICS control register 1
                +CTL2      - initialization value for the ICS control register 2
                +TrimValue - Trim value for trimming the internal clock reference
                             This parameter is only used when internal clock 
                             reference is selceted 
                +CTL3      - initialization value for the ICS control register 3
Returns			  :	NONE
Notes         :	Configures ICS
******************************************************************************/
void ICS_Config(unsigned char CTL1, unsigned char CTL2,unsigned short TrimValue, unsigned char CTL3)
{
 
 if(CTL1 & IREFS_INTERNAL)
  {
   /* internal clock reference is */
  ICSC1           = CTL1;      /* init ISC control register 1 */
  ICSC2           = CTL2;      /* init ISC control register 2 */
 

  ICSTRM = (unsigned char)TrimValue;
  if (TrimValue & 0x0100)
    ICSSC  |= 0x01;
  else
    ICSSC  &= ~0x01;        
    
  ICSSC = CTL3;
  
    if(ICSC1_CLKS == 0b01){
      /* FBI Mode wait for CLKST */
      while (ICSSC_CLKST != ICSC1_CLKS);
    }
    else {
      /* FEI Mode wait for CLKST and DRST */
      while (ICSSC_CLKST != ICSC1_CLKS);
      while ((ICSSC&ICSSC_DRST_DRS_MASK) != (CTL3&ICSSC_DRST_DRS_MASK) );
   
    }
  }
 else
  {
    ICSC2           = CTL2;      /* init ISC control register 2 */  
    ICSC1           = CTL1;      /* init ISC control register 1 */
    ICSSC           = CTL3;

    /*wait until oscillator has been initialized */
    while(!ICSSC_OSCINIT); 
    }
    
    
    if(ICSC1_CLKS == 0b10){
      /* FBE Mode wait for CLKST */
      while (ICSSC_CLKST != ICSC1_CLKS);
    }
    else {
      /* FEE Mode wait for CLKST and DRST */
      while (ICSSC_CLKST != ICSC1_CLKS);
      while ((ICSSC&ICSSC_DRST_DRS_MASK) != (CTL3&ICSSC_DRST_DRS_MASK) );
   
    }
  }
 
