/**********************************************************************
* HEADER_START                                                        *
*                                                                     *
*      Name:           main.c                                         *
*      Project:        Developper's HC08 Bootloader Slave             *
*      Description:    S08JM main bootloader file                     *
*      Platform:       Linux/Win32                                    *
*      Date:           June 22 2009                                    *
*      Author:         B20253                                         *
*      Company:        Freescale                                      *
*      Security:       General Business                               *
*                                                                     *
* =================================================================== *
* Copyright (c):       FREESCALE Inc., 2009, All rights reserved.     *
*                                                                     *
* =================================================================== *
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY              *
* EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE *
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR  *
* PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL FREESCALE OR             *
* ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    *
* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT        *
* NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;        *
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, *
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)       *
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED *
* OF THE POSSIBILITY OF SUCH DAMAGE.                                  *
* =================================================================== */
#include <hidef.h>      /* for EnableInterrupts macro      */
#include "derivative.h" /* include peripheral declarations */
#include "DoOnStack_CFV1.h"

char tabulka[]={0x54, 0x45, 0x53, 0x54, 0x49, 0x4E, 0x47, 0x20, 0x46, 0x4C, 0x41, 0x53, 0x48, 0x20, 0x50, 0x52,
                0x4F, 0x47, 0x52, 0x41, 0x4D, 0x4D, 0x49, 0x4E, 0x47, 0x20, 0x52, 0x4F, 0x55, 0x54, 0x49, 0x4E,
                0x45, 0x53, 0x20, 0x46, 0x4F, 0x52, 0x20, 0x20, 0x33, 0x32, 0x20, 0x42, 0x49, 0x54, 0x53, 0x20,
                0x4D, 0x49, 0x43, 0x52, 0x4F, 0x43, 0x4F, 0x4E, 0x54, 0x52, 0x4F, 0x4C, 0x4C, 0x45, 0x52, 0x53,
                0x20, 0x46, 0x52, 0x45, 0x45, 0x53, 0x43, 0x41, 0x4C, 0x45, 0x20, 0x43, 0x4F, 0x4C, 0x44, 0x46,
                0x49, 0x52, 0x45, 0x20, 0x56, 0x31, 0x20, 0x4D, 0x43, 0x46, 0x35, 0x31, 0x4A, 0x4D, 0x2C, 0x4D,
                0x43, 0x46, 0x35, 0x31, 0x51, 0x45, 0x2C, 0x4D, 0x43, 0x46, 0x35, 0x31, 0x43, 0x4E, 0x2C, 0x4D,
                0x43, 0x46, 0x35, 0x31, 0x41, 0x43, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
                0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
                0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
                0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
                0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
                0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
                0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
                0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
                0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A};

void main(void)
 {
 
 /* Sample of set up oscilator for MCU MCF51JM*/ 
   MCGC2 = 0x00;       
   MCGC1 = 0x06;         
   MCGC3 = 0x01;
   MCGC4 = 0x02;  
                                      //bus clock = Mcgout/2 = 24MHz
   while(!MCGSC_LOCK) {                 /* Wait until FLL is locked */
  }


/*****************************************************************/  
  #if(MCU == MCF51_JM_QE_CN_AC)       /* for others versions of MCUs with core Cold Fire V1 (fbus=24Mhz) */
   FCDIV = 0x4E;
  #else if(MCU == MCF51EM)            /*for EM version with two seperate flash memory blocks*/
   F1CDIV = 0x4E;
   F2CDIV = 0x4E;
  #endif
/*****************************************************************/  

   Page_Erase((unsigned int*)0x1000);
   Burst_Prog((unsigned int*)0x1000,(unsigned int*)tabulka,(unsigned char)256);

 }                       
    
    
    
    
    
    
    
    
    
    
       