 #ifndef _HCS08SPRG_H
 #define _HC0S8SPRG_H


 typedef union
{
    struct{
        unsigned char byte03;         //  first byte of address
        unsigned char byte02;         //  second byte of address
        unsigned char byte01;         //  third byte of address
        unsigned char byte00;         //  fourth byte of address
    } b;
       unsigned char * w;
     
} HILOWORD;


#define DATA_SIZE 64

typedef union{
  unsigned char data8[DATA_SIZE];
  unsigned long int data32[DATA_SIZE / 4];
      
}FILE_PTR_DATA;

 
typedef struct{
    unsigned char datasize;
    HILOWORD addr;
    FILE_PTR_DATA data;
} FILE_PTR_STR;


typedef union{
    struct {
        int numflash;          // number of flash blocs
        int * flsbeg;          // start of flash memory
        int * flsend;          // end of flash memory
        int * flsbeg2;         // start of flash memory
        int * flsend2;         // end of flash memory
        int * intvect;         // start of interrupt vectors table
        int * relintvect;      // start of interrupt vectors table
        int erblklen;          // erase page length
        int wrblklen;          // write page length 
    } idx;
    char str[7];
} IDENT_STR;  


byte address[3];
unsigned int * p_address;

#define RESET_VALUE       0x1D2
#define TRIMM_VALUE_EM    0xB3
#define NUMBER_OF_VECTOR  111
#define START_RAM_VEC     0x000800000

#define FLASH_WRITE_PAGE  128
#define FLASH_ERASE_PAGE  1024


#define WAIT_CONST 65535
#define BYTE 4
#define RESET_APP   0x1D0  
#define ASM_JUMP    0x4EF9 << 16 

#define PROTOCOL_VERSION  0x84
#define FCACK   0xFC
#define READ    0x52
#define WRITE   0x57
#define ERASE   0x45
#define IDENT   0x49
#define QUIT    0x51

#define TRUE   1
#define SET    1
#define FALSE  0

#endif
