/******************************************************************************
*
* Freescale Inc.
* (c) Copyright 2004-2009 Freescale Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     rf_comm_pr.h
* @version  0.0.6.0
* @date     Nov-6-2009
* @author   b020253
* 
* @brief   private rf_comm_pr.h file 
*           
* 
*******************************************************************************/
#ifndef RF_COMM_PR_H
#define RF_COMM_PR_H


typedef struct {
  byte data_len;
}tRF_COMM_TX;


#define SMAC_WORK_CHANNEL 13 
 
/* TOTAL NUMBER OF EVENTS*/
#define EVENT_COUNT 6

/******************************************************************************
* ALL USED EVENTS
******************************************************************************/
#define EVENT_TXDONE       0x01     
#define EVENT_INIT         0x02
#define EVENT_SEND_ACK     0x04
#define EVENT_SEND_BUFF    0x08
#define EVENT_SEND_NACK    0x10
#define EVENT_CHECK        0x20


typedef void(*PFC)(void);

typedef union
{
    word w;
    signed int sw;
    struct{
        byte hi;
        byte lo;
    } b;
} tWORDBYTE;
       
/* size of largest data portion */     
#define RF_COMM_DATA_BUFFER_LEN 	110 

/******************************************************************************
* Complete PACKET STRUCTURE
******************************************************************************/
typedef struct 
{
  word         netnum;
  byte         command;
  byte         packetId;
  byte         deviceId;
  byte         dummy;
  byte         data[RF_COMM_DATA_BUFFER_LEN];
} tRF_COMM;

#define RF_C(x) ((tRF_COMM *)((x)->pu8Data))

/* internal number of the net */
#define RF_COMM_NETNUM 0x9876   

/******************************************************************************
* ALL USED COMMANDS in packet structure
******************************************************************************/
#define RF_COMM_CMD_DATA        'D'//0x10
#define RF_COMM_CMD_HANDSHAKE   'H'//0x20
#define RF_COMM_CMD_ACK         'A'//0x30
#define RF_COMM_CMD_NACK        'N'//0x30

/* Length of buffer */
#define DATA_BUFFER_LEN sizeof(tRF_COMM)
/* Length of Header only */
#define RF_COMM_HEADER_LEN (DATA_BUFFER_LEN - RF_COMM_DATA_BUFFER_LEN)

/******************************************************************************
* Global non-API functions (used internally in driver)
******************************************************************************/
static void RF_Comm_Init(void);
static void RF_Comm_Check_device(void);
static void RF_Comm_SendAck(void);
static void RF_Comm_SendBuffer(void);
static void RF_Comm_TX_done(void);
static void RF_Comm_SendNack(void);
static void RF_Comm_TxGenerator(byte tx_command);
static void Timer_init(void);
static void RF_Comm_ChangeLinkState(LINK_STATE new_state);

#endif RF_COMM_PR_H