/******************************************************************************
*
* Freescale Inc.
* (c) Copyright 2004-2009 Freescale Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     rf_comm.h
* @version  0.0.6.0
* @date     Nov-6-2009
* @author   b020253
* 
* @brief   public rf_comm h file 
*           
* 
*******************************************************************************/
#ifndef RF_COMM_H
#define RF_COMM_H

#include "freescale_radio_hardware.h"

#define LED_1 LED1
#define LED_2 LED2
#define LED_3 LED3

/******************************************************************************
* LINK STATE enumeration 
******************************************************************************/
typedef enum
{
  NOT_CONNECTED = 0, READY = 1, BUSY = 2  
}LINK_STATE;

/******************************************************************************
* API functions 
******************************************************************************/
void RF_Comm_Init1(void);
void RF_Comm_Poll(void);
byte RF_Comm_TxBuffFlush(void);
byte RF_Comm_TxBuff(byte *ptr_data,byte len);
byte RF_Comm_TxBuffPending(void);
LINK_STATE RF_Comm_GetLinkState(void); 

/******************************************************************************
* Callbacks functions 
******************************************************************************/
#ifdef RFCOMM_CHANGE_STATE_CB
  void RFCOMM_CHANGE_STATE_CB(LINK_STATE new_state);
#endif
#ifdef DATA_RECEIVE_CB
  byte DATA_RECEIVE_CB(byte * ptr_receive_buffer,byte length);
#endif

#endif RF_COMM_H
