/*!
 * Copyright (c) 2005, Freescale Semiconductor
 *
 * \file    mcu_spi_config.c
 * \brief   This is the SMAC C source for the SPI driver
 * \author  Larry Roshak
 * \version 4.1a
 * \date    2005/08/11 20:44:37 
 * 
 * \b Description:
 *
 * This is the SMAC C source driver file for the 
 * The driver control interface to the SPI.
 *
 * \b Department: Freescale Radio Products Division 
 *
 * \b Project: SMAC (Simple Media Access Controller)
 *
 * \b History:
 * - 17/04/2004 : Initial Development. (FLR005)
 * - 07/01/2005 : Code Standarization. (A19259)
 * - 11/16/2005 Doc. update to Doxygen compliant by Gonzalo Delgado 
 * Huitron rgd04c
 */ 

#include "derivative.h"
#include "pub_def.h"
#include "mcu_hw_config.h"
#include "drivers.h"
#include "MC13192_hw_config.h"
#include "MC13192_regs.h"
#include "mcu_spi_config.h"


/*!
  \fn void SPIInit(void)
  \brief Initialize the SPI Control and Baud Rate Registers
*/
void SPIInit(void){
#ifdef HC08JW
    
    SPCR = 0b00100010;  /* CPOL = 0, CPHA = 0, SPE = 1, ints' disabled */
    SPSCR = 0b00000000; /* clock/2, MODF dis. */

#else
    SPI1C1 = 0x50;   /*  
                      *  0b01010000
                      *    ||||||||__ SPI serial data transfers start with MSB
                      *    |||||||___ SS1 used as GPIO
                      *    ||||||____ First edge occurs at the middle of cycle
                      *    |||||_____ Active-high SPI clock
                      *    ||||______ SPI Configured as Master
                      *    |||_______ SPI Transmit Interrupt Disabled
                      *    ||________ SPI System Enabled
                      *    |_________ SPI Interrupt Disabled
                      */
    SPI1C2 = 0x00;   /*  
                      *  0b00000000
                      *    ||||||||__ Separate pins for data input and output.
                      *    |||||||___ SPI clocks operate in wait mode.
                      *    ||||||____ Unimplemented
                      *    |||||_____ SPI data I/O pin acts as an input.
                      *    ||||______ Mode Fault Disabled
                      *    |||_______ Unimplemented
                      *    ||________ Unimplemented
                      *    |_________ Unimplemented
                      */
    SPI1BR = 0x10;   /*  
                      *  0b00000000
                      *    |||||||| 
                      *    ||||||||
                      *    ||||||++-- Rate Divisor = 2
                      *    |||||_____ Unimplemented
                      *    |||| 
                      *    |||| 
                      *    ||++------ Prescaler Divisor = 0 
                      *    |_________ Unimplemented
                      */
   // PTEPF1 = 0x06;
   // PTEPF2 = 0x80;
#endif
}


#if defined (HCS08G) | defined (HCS08R) | defined (HCS08Q) | defined (MCF51HCS08JM)

void SPIWaitTransferDone(void)
{
  UINT16 tmp_cnt = 0xffff;
  
  while ((!(SPI1S_SPRF)) && (tmp_cnt--))
  {
  };
}
#endif