/*!
 * Copyright (c) 2005, Freescale Semiconductor
 *
 * \file    mcu_hw_config.h
 * \brief   Header used to select the desired core.
 * \author  a20639
 * \version 4.1a
 * \date    2005/08/11 20:44:37 
 * 
 * \b Description:
 *
 * Header that includes the declaration of the methods used to
 * configure the hardware
 *
 * \b Department: Freescale Radio Products Division 
 *
 * \b Project: SMAC (Simple Media Access Controller)
 *
 * \b History:
 * - 11/16/2005 Doc. update to Doxygen compliant by Gonzalo Delgado 
 * Huitron rgd04c
 */ 

//#ifndef _MCU_HW_CONFIG_H
#define _MCU_HW_CONFIG_H
#include "freescale_radio_hardware.h"
#include "pub_def.h"


/* Defines */

#if defined(__HCS08__) | defined(HC08JW)
  #define MCU_LOW_POWER_WHILE() _asm wait			/*!<Low power Wait instruction*/
#else
  #define MCU_LOW_POWER_WHILE() /*asm { stop }//*/asm {nop };//_Wait			/*!<Low power Wait instruction*/
#endif
//void AssertCE(void);
#define AssertCE() MC13192_CE = 0 /*!< Asserts the MC13192 CE pin */            
//void DeAssertCE(void);          
#define DeAssertCE() MC13192_CE = 1  /*!< Deasserts the MC13192 CE pin */
//void RTXENDeAssert(void) ;      
#ifndef RXTXEN_NOT_USED
  #define RTXENDeAssert() MC13192_RTXEN = 0; /*!< Deassert RTXEN */
#else
  #define RTXENDeAssert() ;
#endif //RXTXEN_NOT_USED
  
//void RTXENAssert(void);         
  
#ifndef RXTXEN_NOT_USED
  #define RTXENAssert() MC13192_RTXEN = 1; /*!< Assert RTXEN */
#else
  #define RTXENAssert() ;
#endif //RXTXEN_NOT_USED
  
//void MC13192Wake(void);         

#ifndef ATTN_NOT_USED
  #define MC13192Wake()  MC13192_ATTN = 0; /*!< Assert ATTN */ \
    MC13192_ATTN = 1;  /*!< Deassert ATTN */
#else
  #define MC13192Wake();
#endif //ATTN_NOT_USED
  
void MC13192Restart(void);
void MC13192ContReset(void);
                               

#ifdef HC08JW
  #define IRQFLAG                     KBSCR_KEYF	 /*!< IRQ Flag*/
  #define IRQACK()                    KBSCR_ACKK = 1 /*!< IRQ Acknowledge enabled*/
  #define IRQInit()                   /*DDRA_DDRA3 = 1; PTA_PTA3 = 1;*/ KBIER_KBIE3 = 1; KBSCR_MODEK = 1;   /*!< Configures IRQ*/
  #define IRQPinEnable()              KBSCR_IMASKK = 1; IRQInit();IRQACK(); KBSCR_IMASKK = 0  /*!<Enables IRQ pin */
  #define IRQ_Disable()               KBIER_KBIE3 = 0;//KBIER = 0x00 /*!< Set for negative edge. */
  #define MC13192_IRQ_Disable()       ;//IRQ_Disable() //MC13192_IRQ_SOURCE = MC13192_IRQ_SOURCE & ~(0x06) /*!<Disables MC13192 transceiver */
  #define MC13192_IRQ_Enable()        IRQPinEnable() //MC13192_IRQ_SOURCE = MC13192_IRQ_SOURCE | (0x02)  /*!<Enables MC13192 transceiver */

  //    MC13192_IRQ_SOURCE = gu8IRQValue;
  #define CLEAR_IRQ_FLAG()            IRQACK()	 /*!< Clears IRQ flag*/

#else

  #define IRQFLAG                     IRQSC_IRQF	 /*!< IRQ Flag*/
  #define IRQACK()                    IRQSC |= 0x04 /*!< IRQ Acknowledge enabled*/
  #define IRQInit()                   { IRQSC = 0x14;  }  /*!< Configures IRQ*/
  #define IRQPinEnable()              IRQSC = 0x16  /*!<Enables IRQ pin */
  #define IRQ_Disable()               IRQSC = 0x00;/*!< Set for negative edge. */
  #define MC13192_IRQ_Disable()       MC13192_IRQ_SOURCE = (UINT8)(MC13192_IRQ_SOURCE & ~(0x06)) /*!<Disables MC13192 transceiver */
  #define MC13192_IRQ_Enable()        MC13192_IRQ_SOURCE = (UINT8)(MC13192_IRQ_SOURCE | (0x02))  /*!<Enables MC13192 transceiver */

  //    MC13192_IRQ_SOURCE = gu8IRQValue;
  #define CLEAR_IRQ_FLAG()            IRQACK()	 /*!< Clears IRQ flag*/

#endif

/* Declarations */
#if defined(__HCS08__) | defined(HC08JW)
  #pragma DATA_SEG SHORT _DATA_ZEROPAGE
   extern  UINT8 gu8RTxMode;						        //!< Global mode mirror. MC13192 Status. 
  #pragma DATA_SEG DEFAULT
#else
  extern  UINT8 gu8RTxMode;						        //!< Global mode mirror. MC13192 Status. 
#endif
  
/* Function Prototypes */
void GPIOInit(void);
#if defined (HCS08G) || defined (HCS08R) || defined (MC1321X)
void UseExternalClock(void);
void UseMcuClock(void);
#endif
void MCUInitQuick(void);
void MCUInit(void);
UINT8 IRQPinLow(void);




//#endif /* _MCU_HW_CONFIG_H */