/*
 * $Author: a20639 $
 * $Date: Sep-12-2007$
 * $Name:  $
 */
 
/* includes */
#include "pub_def.h"
#include "board_config.h"
/* Prototypes */
void RadioInit(void);

/* Defines */



#define MC1321X
#define HCS08G
#define MC13192_CE              PTED_PTED2                
#define MC13192_CE_PORT         PTEDD_PTEDD2                
#define MC13192_ATTN            PTDD_PTDD0
#define MC13192_ATTN_PORT       PTDDD_PTDDD0
#define MC13192_RTXEN           PTDD_PTDD1
#define MC13192_RTXEN_PORT      PTDDD_PTDDD1
#define MC13192_RESET           PTDD_PTDD3
#define MC13192_RESET_PORT      PTDDD_PTDDD3
#define MC13192_RESET_PULLUP    PTDPE_PTDPE3
#define MC13192_IRQ_SOURCE      IRQSC
#define MC13192_IRQ_IE_BIT      IRQSC_IRQIE

/* Antenna Switch/PA can be implemented via the CT_Bias control line */
/* See the MC1321x reference manual */


/**************************************************************
Enable peripherials that are on the Board
**************************************************************/

#define ACCEL_ENABLED         FALSE
#define TEMP_SENSOR_ENABLED   FALSE
#define BUZZER_ENABLED        FALSE    
#define DEFAULT_BUS_SPEED	   8000000

/**************************************************************
Define the SCI perameters
**************************************************************/

#if (DEFAULT_SCI_PORT == 1)
   #define  SCIBDH     SCI1BDH
   #define  SCIBDL     SCI1BDL
   #define  SCIC1      SCI1C1 
   #define  SCIC2      SCI1C2 
   #define  SCIS1      SCI1S1 
   #define  SCIS2      SCI1S2 
   #define  SCIC3      SCI1C3 
   #define  SCID       SCI1D

   #define  SCIS1_TDRE  SCI1S1_TDRE
   #define  SCIS1_TC    SCI1S1_TC

   #define  RTS			PTAD_PTAD1
   #define  RTSDIR		PTADD_PTADD1
#else 

   #define  SCIBDH     SCI2BDH
   #define  SCIBDL     SCI2BDL
   #define  SCIC1      SCI2C1 
   #define  SCIC2      SCI2C2 
   #define  SCIS1      SCI2S1 
   #define  SCIS2      SCI2S2 
   #define  SCIC3      SCI2C3 
   #define  SCID       SCI2D

   #define  SCIS1_TDRE  SCI2S1_TDRE
   #define  SCIS1_TC    SCI2S1_TC

   #define  RTS			PTAD_PTAD6
   #define  RTSDIR		PTADD_PTADD6
#endif  */
#define  SCI_DEFAULT_BAUD  38400

/**************************************************************
Define the LED perameters
**************************************************************/

#define LED1                    PTBD_PTBD7
#define LED1DIR                 PTBDD_PTBDD7
#define LED2                    PTBD_PTBD4
#define LED2DIR                 PTBDD_PTBDD4
#define LED3                    PTBD_PTBD5
#define LED3DIR                 PTBDD_PTBDD5
#define LED4                    PTBD_PTBD6
#define LED4DIR                 PTBDD_PTBDD6
    
#define LED_ON                  0
#define LED_OFF					        1
#define DDIR_OUTPUT             1
#define DDIR_INPUT              0
    
#define LED_INIT_MACRO LED1     = LED_OFF; \
                       LED2     = LED_OFF; \
                       LED3     = LED_OFF; \
                       LED4     = LED_OFF; \
                       LED1DIR  = DDIR_OUTPUT; \
                       LED2DIR  = DDIR_OUTPUT; \
                       LED3DIR  = DDIR_OUTPUT; \
                       LED4DIR  = DDIR_OUTPUT;        
    
/***********************************************
Define Buzzer
***********************************************/
    
/*    
#define BUZZER         PTDD_PTDD2
#define BUZZERDIR      PTDDD_PTDDD2
#define BUZZER_ON      1
#define BUZZER_OFF     0
   
#define BUZZER_INIT_MACRO BUZZER      = BUZZER_OFF; \
                          BUZZERDIR   = DDIR_OUTPUT;
*/

/**************************************************************
Define the SPI perameters
**************************************************************/

 #define  SPI1C1     SPIC1
 #define  SPI1C2     SPIC2
// #define  SPI1BR     SPIBR
// #define  SPI1S_SPRF  SPIS_SPRF
// #define  SPI1S      SPIS
// #define  SPI1D      SPID
    
/***********************************************
Define Switches
***********************************************/
    
    
/* SW1 on schematic */
#define PB0 PTCD_PTCD4
#define PB0PU PTCPE_PTCPE4
#define PB0DIR PTCDD_PTCDD4
//#define PB0IE KBI1PE_KBIPE2
  
/* SW2 on schematic */
#define PB1 PTCD_PTCD5
#define PB1PU PTCPE_PTCPE5
#define PB1DIR PTCDD_PTCDD5
//#define PB1IE KBI1PE_KBIPE3
   
/* SW3 on schematic */
#define PB2 PTCD_PTCD6
#define PB2PU PTCPE_PTCPE6
#define PB2DIR PTCDD_PTCDD6
//#define PB2IE KBI1PE_KBIPE4
  
/* SW4 on schematic */
#define PB3 PTCD_PTCD7
#define PB3PU PTCPE_PTCPE7
#define PB3DIR PTCDD_PTCDD7
//#define PB3IE KBI1PE_KBIPE5

/* Define the KBI Pins */
//#define KBI_SW1 0x04
//#define KBI_SW2 0x08
//#define KBI_SW3 0x10
//#define KBI_SW4 0x20

#define SWITCH_INIT_MACRO    PB0PU = TRUE; \
                             PB1PU = TRUE; \
                             PB2PU = TRUE; \
                             PB3PU = TRUE; \
                             PB0DIR = FALSE;\
                             PB1DIR = FALSE;\
                             PB2DIR = FALSE;\
                             PB3DIR = FALSE;
    
/***********************************************
Define Port B
Accelerometer and LCD
***********************************************/
/*
#define ACCEL_X           PTBD_PTBD2
#define ACCEL_Y           PTBD_PTBD3
#define ACCEL_Z           PTBD_PTBD4
#define ACCEL_PS          PTBD_PTBD5
#define ACCEL_GSELECT1    PTBD_PTBD1
#define ACCEL_GSELECT2    PTBD_PTBD0

#define ACCEL_START_X     ATD1SC = 2;
#define ACCEL_START_Y     ATD1SC = 3;
#define ACCEL_START_Z     ATD1SC = 4;     
  
#define ACCEL_INIT_MACRO  PTBDD_PTBDD2 = DDIR_INPUT; \
                          PTBDD_PTBDD3 = DDIR_INPUT; \
                          PTBDD_PTBDD4 = DDIR_INPUT; \
                          PTBDD_PTBDD5 = DDIR_OUTPUT; \
                          PTBDD_PTBDD1 = DDIR_OUTPUT; \
                          PTBDD_PTBDD0 = DDIR_OUTPUT;

#define ACCEL_G_OFF       ACCEL_PS = 0;
#define ACCEL_G_ON        ACCEL_PS = 1; 
#define ACCEL_G_1p5       ACCEL_GSELECT1 = 0; ACCEL_GSELECT2 = 0;
#define ACCEL_G_2p0       ACCEL_GSELECT1 = 0; ACCEL_GSELECT2 = 1;
#define ACCEL_G_4p0       ACCEL_GSELECT1 = 1; ACCEL_GSELECT2 = 0;
#define ACCEL_G_6p0       ACCEL_GSELECT1 = 1; ACCEL_GSELECT2 = 1;
*/                          
/***********************************************
LCD Settings
***********************************************/
/*
#define LCD_ENABLE        PTBD_PTBD0
#define LCD_REG_SEL       PTBD_PTBD1
#define LCD_EN            PTBD_PTBD2
#define LCD_RW            PTBD_PTBD3
*/    /* Data bits are 4-7 */
/*#define LCD_DATA1         PTBD_PTBD4
#define LCD_DATA2         PTBD_PTBD5
#define LCD_DATA3         PTBD_PTBD6
#define LCD_DATA4         PTBD_PTBD7
                              
#define LCD_INIT_MACRO    PTBDD = 0xFF;  // Set whole port to output 
    
*/                              
                              
#define ENTER_LOW_POWER _asm stop

/***********************************************
Duplicate PB0 to PUSH_BUTTON1 etc for different
formats.
***********************************************/

#define PUSH_BUTTON1 PB0
#define PUSH_BUTTON2 PB1
#define PUSH_BUTTON3 PB2
#define PUSH_BUTTON4 PB3

#define PB_PRESSED 0

