/*!
 * Copyright (c) 2005, Freescale Semiconductor
 *
 * \file    MC13192_regs.h
 * \brief   Defines the MC13192 registers.
 * \author  a19259
 * \version 4.1a
 * \date    2005/07/29 02:27:50 
 *
 * \b Department: Freescale Radio Products Division 
 *
 * \b Project: SMAC (Simple Media Access Controller)
 *
 * \b History:
 * - 16/11/2005 Doc. update to Doxygen compliant by Mario Rodriguez r12369c
 */ 
 
#ifndef _MC13192_REGS_H
#define _MC13192_REGS_H

/*! MC13192 soft reset */
#define ZIG_RESET                   0x00		/*!< Reset */

/* Packet RAM */
#define ZIG_RX_PKT                  0x01    /*!< RX Packet RAM */
#define ZIG_RX_PKT_LEN              0x2D    /*!< RX Packet RAM Length [6:0] */  
#define ZIG_TX_PKT                  0x02    /*!< TX Packet RAM */
#define ZIG_TX_PKT_LEN              0x03    /*!< TX Packet RAM Length */
#define ZIG_TX_PKT_LEN_MASK         0x007F  /*!< TX Packet RAM Length Mask */

/* IRQ Status Register */
#define ZIG_IRQ_MASK                0x05		/*!< IRQ Mask */
#define ZIG_STATUS_ADDR             0x24		/*!< Status bits that can cause an interrupt request when enabled */
#define ZIG_RESIND_ADDR             0x25		/*!< Reset indicator bit */
#define ZIG_TIMER1_IRQMASK_BIT      0x0001  /*!< Timer1 IRQ mask bit */

/* Mask and mode */
#define ZIG_MODE_ADDR               0x06    /*!< Control fields for the MC13192/93 */
#define ZIG_MODE2_ADDR              0x07    /*!< Control fields for the MC13192/93 */ 
#define ZIG_LO1_COURSE_TUNE         0x8000  /*!< LO1 course tune */ 

/* Main Timer */
#define ZIG_TIMER_PRESCALE          0x09    /*!< Timer Prescale */
#define ZIG_EVENTTIMER_HI_ADR       0x26
#define ZIG_EVENTTIMER_LO_ADR       0x27
#define ZIG_TIMESTAMP_HI_ADDR       0x2E    /*!< Timestamp hi address */
#define ZIG_TIMESTAMP_LO_ADDR       0x2F		/*!< Timestamp lo address */
#define ZIG_TIMESTAMP_HI_MASK       0x00FF  /*!< Timestamp hi mask */

/* Frequency */
#define ZIG_XTAL_ADJ_ADDR           0x0A		/*!< Xtal trim and clock rate */
#define ZIG_CLKS_ADDR               0x0A		/*!< Xtal trim and clock rate */
#define ZIG_LO1_IDIV_ADDR           0x0F		/*!< LO1 fractional-N synthesizer that sets transceiver channel freq */
#define ZIG_LO1_NUM_ADDR            0x10		/*!< Sets transceiver channel frequency */
#define ZIG_PRESCALE_ADDR           0x09		/*!< tmr_prescale[2:0] select the frequency of the base clock for the Event Timer */

/* Timer comparators */
#define ZIG_T1_HI_ADDR              0x1B    /*!< Timer1 comparator most significant 8 bits of the 24-bit compare */
#define ZIG_T1_LO_ADDR              0x1C		/*!< Timer1 comparator least significant 16 bits */
#define ZIG_T2_HI_ADDR              0x1D    /*!< Disable bit for Timer Comparator 2 and stores the most significant 8 bits */
#define ZIG_T2_LO_ADDR              0x1E		/*!< least significant 16 bits of the 24-bit compare value.*/
#define ZIG_T3_HI_ADDR              0x1F    /*!< Disable bit for Timer Comparator 3 and stores the most significant 8 bits */
#define ZIG_T3_LO_ADDR              0x20		/*!< least significant 16 bits of the 24-bit compare value.*/
#define ZIG_T4_HI_ADDR              0x21    /*!< Disable bit for Timer Comparator 4 and stores the most significant 8 bits */
#define ZIG_T4_LO_ADDR              0x22		/*!< least significant 16 bits of the 24-bit compare value.*/



/* CCA */
#define ZIG_CCA_THRESHOLD           0x04	  /*!< Threshold value for Clear Channel Assessment in dB-linear format */
#define ZIG_CCA_RESULT_ADDR         0x2D		/*!< Bits 15-8 cca_final [7:0]  Average CCA energy */
#define ZIG_FEGAIN_ADDR             0x04		/*!< added to the measured value of the CCA operation */

/* TX */
#define ZIG_PA_ADJUST_ADDR          0x12		/*!< sets the power level and drive level of the transmitter power amplifier.*/

/* GPIO */
#define ZIG_GPIO_CONFIG             0x0B		/*!< config. data direction + sets output drive strength of GPIO1 through GPIO4*/
#define ZIG_GPIO_DATA               0x0C		/*!< sets output value if GPIO configured as output + set the output drive strength of GPIO5 through GPIO7*/
#define ZIG_GPIO_DATA_MASK          0x003F  /*!< GPIO data mask */

/* Version */
#define ZIG_VERSION_REG             0x2C		/*!< 9-bit chip version code */
#define ZIG_VERSION_MASK            0x1C00  /*!< Version mask */

/******* Test registers *******/
#define ZIG_BER_REG                 0x30    /*!< Bit error rate register */
#define ZIG_BER_MASK                0x8000   /*!< Bit error rate mask */
#define ZIG_PSM_REG                 0x31     /*!< PSM register */
#define ZIG_PSM_MASK                0x0008   /*!< PSM mask */
#define ZIG_PAEN_REG                0x08     /*!< PA enable register */
#define ZIG_PAEN_MASK               0x8000   /*!< PA enable mask  */

#endif /* _MC13192_REGS_H */