#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */

#include "SCI.h"
#include "rf_comm.h"


LINK_STATE RfComm_GetLinkState(void);
extern byte RfComm_TxBuff(byte *ptr_data,byte len);
extern void RfComm_LinkStateChangedCB(LINK_STATE new_state);

/******************************************************************************
* Callbacks functions RfComm_LinkStateChangedCB
******************************************************************************/
void RfComm_LinkStateChangedCB(LINK_STATE new_state)
{
 
 if(new_state != NOT_CONNECTED)
    LED2 = LEDON;
 else
    LED2 = LEDOFF;
}

/******************************************************************************
* Callbacks functions RfComm_DataReceiveCB
******************************************************************************/
void RfComm_DataReceiveCB(byte * ptr_receive_buffer,byte length)
{
 (void)ptr_receive_buffer;
 (void)length;
} 
 
/******************************************************************************
* MCU init
******************************************************************************/
void MCU_Init(void) 
{
  /* ### MCF51QE128_64 "Cpu" init code ... */
  /*  PE initialization code after reset */
  /* Common initialization of the write once registers */
  /* SOPT1: COPE=0,COPT=1,STOPE=0,WAITE=1,??=0,RSTOPE=0,BKGDPE=1,RSTPE=0 */
  SOPT1 = 0x52;                 
  /* SPMSC1: LVDF=0,LVDACK=0,LVDIE=0,LVDRE=1,LVDSE=1,LVDE=1,??=0,BGBE=0 */
  SPMSC1 = 0x1C;                
  /* SPMSC2: LPR=0,LPRS=0,LPWUI=0,??=0,PPDF=0,PPDACK=0,PPDE=1,PPDC=0 */
  SPMSC2 = 0x02;                
  /* SPMSC3: LVDV=0,LVWV=0,LVWIE=0 */
  SPMSC3 &= ~(byte)(0x38);

  /*  System clock initialization */
  /* ICSC1: CLKS=0,RDIV=0,IREFS=1,IRCLKEN=1,IREFSTEN=0 */
  ICSC1 = 0x06;                /* Initialization of the ICS control register 1 */ 
  /* ICSC2: BDIV=0,RANGE=0,HGO=0,LP=0,EREFS=0,ERCLKEN=0,EREFSTEN=0 */
  ICSC2 = 0x00;                /* Initialization of the ICS control register 2 */ 
  while(!ICSSC_IREFST) {               /* Wait until the source of reference clock is internal clock */
  }
  /* ICSSC: DRST_DRS=2,DMX32=0 */
  ICSSC = (byte) ((byte)((byte)ICSSC & (~(byte)(0x60))) | (byte)(0x80));
  while((ICSSC & 0xC4) != 0x80) {      /* Wait until the FLL switches to High range DCO mode */
  }

}
//////////////////////////////////////////MAIN////////////////////////////////////////////
void main(void)
 {
  MCU_Init();            //  MCU intitialization function
  RF_Comm_Init1();       //  Radio initialization
  
  LED_INIT_MACRO
  
  EnableInterrupts; /* enable interrupts */

  for(;;) 
  {
    RF_Comm_Poll();      // Internal state machine poll function
    __RESET_WATCHDOG(); /* feeds the dog */
  } 
  
}





















