/*
 * Note: This file is recreated by the project wizard whenever the MCU is
 *       changed and should not be edited by hand
 */

#ifdef __HCS08__

  /* Include the derivative-specific header file */
  #include <MC9S08QE128.h>

  #define _Stop asm ( stop; )
    /*!< Macro to enter stop modes, STOPE bit in SOPT1 register must be set prior to executing this macro */

  #define _Wait asm ( wait; )
    /*!< Macro to enter wait mode */

#elif defined(__CWCC__)
    
  /* Include the derivative-specific header file */
  #include <MCF51QE128.h>

  #define _Stop asm ( mov3q #4,d0; bclr.b d0,SOPT1; stop #0x2000; )
    /*!< Macro to enter stop modes, STOPE bit in SOPT1 register must be set prior to executing this macro */

  #define _Wait asm ( mov3q #4,d0; bset.b d0,SOPT1; nop; stop #0x2000; )
    /*!< Macro to enter wait mode */

#else 

  #error "Not supported MCU !"

#endif
    