
#ifndef SCI_H
#define SCI_H


#define BAUDRATE_9600    52
#define BAUDRATE_19200   26
#define BAUDRATE_57600   26     //22 pro 20MHz
#define BAUDRATE_115000  13     //22 pro 20MHz



#define MAX_DATA_SIZE 40

#define MSG_LENGTH 19


#define END_CHAR ']'

#define RECEIVE 0x01
#define RX_IN_PROGRESS 0x02
#define OVERRUN_BUFFER 0x04
#define RX_BAD_MSG 0x08

#define ERR_OK        0
#define ERR_BUSY      1
#define ERR_FORMAT    2


/* definice promennych */
extern byte BufferTx[MAX_DATA_SIZE];
extern byte BufferRx[MAX_DATA_SIZE];
extern volatile byte CountTx;
//extern byte CountRx;
extern byte rx_flag; 


/* definice funkci */
void init_sci(void);
void Disable_sci(void);
void send_char(byte char0);
void send_word(word word0);
void send_3byte(byte byte0, byte byte1, byte byte2);
void send_string(byte *string,byte length);
void send_frame(byte *frame,byte length);
extern void DataIndication(byte *buff);

#endif SCI_H