/********************** START OF THE PROGRAM *****************/

#include "m51em256demo.h"
#include "sci.h"
#include "ascii.h"
#include "com_protocol.h"
#include "infrared.h"


void main(void) 
{
  SOPT1_COPT = 0;   /* Turn off Watchdog Timer*/
  FlashInit();      /*Configures the Flash clock for erase and program operations*/
  
  if(u8SCI_init(USED_PORT, BAUDRATE, DATA_LENGTH_EIGTH, PARITY_NONE, (IR_ACTIVE+1), RX_NOT_INVERTED)) for(;;){};
  if(u8IR_TX_init(USED_PORT, TX_PIN_OPTION_DEFAULT, IR_ACTIVE, MODULATION_DISABLED, TX_INTERRUPT_DISABLED)) for(;;){};
  
  vfnSCI_SendMsg(USED_PORT,"Communication Protocol using MCF51EM256"); 
  /* Send a Welcome string by selected SCI port */
  sendCR();
  
  if(u8IR_RX_init(USED_PORT, RX_PIN_OPTION_DEFAULT, (IR_ACTIVE*REFERENCE_LEVEL), RX_INTERRUPT_ENABLED)) for(;;){};
  
  EnableInterrupts; /* enable interrupts */  
  
  for(;;) 
  {
    communication_protocol();
  }
}/* loop forever */

/* please make sure that you never leave main */



