/////////////////////////////////////////////////////////////////////////////////////////
//
// EEPROM Emulation for MC9S08LC60
// Using 2 arrays of FLASH
//
// --------------------------------------------------------------------------------------
//
// CodeWarrior V5.1 for HC(S)08
// Registers Files version 2.87.175
//
// --------------------------------------------------------------------------------------
// Copyright (c) 2007 Freescale
// http://www.freescale.com/
// 
/////////////////////////////////////////////////////////////////////////////////////////

// Defines

#define   Blanck_Check  0x05          //Blank Check
#define   Byte_Prog     0x20          //Byte Program
#define   Prog_Burst    0x25          //Byte Program - Burst Mode
#define   Page_Erase    0x40          //Page Erase (512 bytes)
#define   Mass_Erase    0x41          //Mass Erase (All Flash)

#define   ERROR         0x1           //ERROR message

#define NVM_ERROR_OK            0  // No error while programming
#define NVM_ERROR_VERIFICATION  1  // after N intents
#define NVM_ERROR_NOT_ERASED    2  // memory to be written is not erased (don't have 0xFF value)



/* EEPROM_functions.h */


unsigned int VEEPROM_search_empty_space (void);                   
void Write_event(unsigned char event);
unsigned char NVM_Read_Byte (unsigned int direccion);

unsigned char NVM_Write_Byte (unsigned int direccion, unsigned char data);

//void ReadDataNVM(void);
//void Download_eventNVM(void);
void PC_NVM_test (void);
//unsigned char NVM_Read_Byte(unsigned int direccion);
void calibration_test(void);
void energy_back_up_test (void);
void Energy_Back_up_power_up (void);
void Energy_back_up (void);

void NVM_Init (void);





