                                              /////////////////////////////////////////////////////////////////////////////////////////
//
// EEPROM Emulation for MC9S08LC60
// Using 2 arrays of FLASH
//
// --------------------------------------------------------------------------------------
//
// CodeWarrior V5.1 for HC(S)08
// Registers Files version 2.87.175
//
// --------------------------------------------------------------------------------------
// Copyright (c) 2007 Freescale
// http://www.freescale.com/
// 
/////////////////////////////////////////////////////////////////////////////////////////
#include <hidef.h> /* for EnableInterrupts macro */
#include  "EEPROM.h"
#include "derivative.h"


#define FSTAT_FACCERR     F1STAT_FACCERR
#define FCDIV             F1CDIV  
#define FPROT             F1PROT  
#define FSTAT_FPVIOL      F1STAT_FPVIOL 
#define FCMD              F1CMD
#define FSTAT_FCBEF       F1STAT_FCBEF  
#define FSTAT_FCCF        F1STAT_FCCF   


void NVM_Init (void) {
  //Set FLASH Clock Divider Register
  FSTAT_FACCERR = 0;                    //Clear access error flag
  FCDIV = 0x27;
  //Set FLASH protection Register
  FPROT = 0x7E;                         //The FLASH protected area is 0x8000 - 0xFFFF
  
}

/***********************************************************************************************************
  Function:    NVM_Write_Byte

  Prototype:   char NVM_Write_Byte(int *dest byte data) 

  Description: It performs the commands on the EEPROM depending on the pCommand parameter

  Input:
         u08  pCommand

         u16 *pDestin  - Destination Address

         u16 *pSource  - Source Address

  Output:

************************************************************************************************************/
/////////////////////////////////////////////////////////////////////////////////////////
// NVM_Write_Byte 
// --------------------------------------------------------------------------------------
// Write a byte in the NVM
/////////////////////////////////////////////////////////////////////////////////////////
/*
void NVM_Write_Byte (unsigned char *dest, char data) 
{
 
  
  
  DisableInterrupts; 

  //if (*dest!=0xFF)        //problem!
  
  
  if (FSTAT_FACCERR == 1 || FSTAT_FPVIOL == 1)        //Verifying error flags
  {
    FSTAT_FACCERR = 1;                                //Clear error flags
    FSTAT_FPVIOL = 1;
  }


  *dest = data;
  FCMD = Byte_Prog;                                   //Byte program command
  FSTAT_FCBEF = 1;                                    //Run the command 
  
  _asm NOP;
  _asm NOP;
  _asm NOP;
  _asm NOP;
  
  
  if (FSTAT_FACCERR == 1 || FSTAT_FPVIOL == 1)        //Verifying error flags
  {
    FSTAT_FACCERR = 1;                                //Clear error flags     Problem!
    FSTAT_FPVIOL = 1;
  }
  
  while (FSTAT_FCCF == 0);
  
 EnableInterrupts; 
  
}

*/

/////////////////////////////////////////////////////////////////////////////////////////
// NVM_Read_Byte 
// --------------------------------------------------------------------------------------
// Read a byte stored in the NVM
/////////////////////////////////////////////////////////////////////////////////////////

/*void NVM_Read_Byte (unsigned char *addr, unsigned char *data) 
{



  *data = *addr;

 
}*/




/////////////////////////////////////////////////////////////////////////////////////////
// NVM_Erase_Page
// --------------------------------------------------------------------------------------
// Erase a 512-byte page in the NVM
/////////////////////////////////////////////////////////////////////////////////////////

/*void NVM_Erase_Page (unsigned int addr) 
{
unsigned int *erase_addr;
  unsigned char dummy;

erase_addr=(unsigned int *) addr;
  

  
    if (FSTAT_FACCERR == 1 || FSTAT_FPVIOL == 1)        //Verifying error flags
  {
    FSTAT_FACCERR = 1;                                //Clear error flags
    FSTAT_FPVIOL = 1;
  }

  *erase_addr = dummy;
  FCMD = Page_Erase;                                   //Byte program command
  FSTAT_FCBEF = 1;                                    //Run the command 
  
  _asm NOP;
  
  
  if (FSTAT_FACCERR == 1 || FSTAT_FPVIOL == 1)        //Verifying error flags
  {
    FSTAT_FACCERR = 1;                                //Clear error flags
    FSTAT_FPVIOL = 1;
  }
  
  while (FSTAT_FCCF == 0);
}*/

/////////////////////////////////Nuevas funciones de EEPROM /////////////////////////////////

unsigned char NVM_Read_Byte (unsigned int direccion) 
{
unsigned char *destino;
  
destino=(unsigned char *) direccion;
return *destino;
}




//////////////////////// WRITE 2


unsigned char NVM_Write_Byte (unsigned int direccion, unsigned char data) 
{
   unsigned char *destino;
   unsigned char intentos;
  
  intentos = 3;
  
  destino=(unsigned char *) direccion; 
  
  if ( 0xFF != *destino)  return NVM_ERROR_NOT_ERASED;
   

  while (intentos--) 
  {
   if (FSTAT_FACCERR == 1 || FSTAT_FPVIOL == 1)        //Verifying error flags
   {
    FSTAT_FACCERR = 1;                                //Clear error flags
    FSTAT_FPVIOL = 1;
   }
   *destino = data;
   FCMD = Byte_Prog;                                   //Byte program command
   FSTAT_FCBEF = 1;                                    //Run the command 

   asm (NOP);
   asm (NOP);
   asm (NOP);
   

   while (FSTAT_FCCF == 0){};
   if (*destino == data) return NVM_ERROR_OK ;
  }
  return NVM_ERROR_VERIFICATION ;
}


//******************************************
// Each page has 512 bytes = 1 sector and it is the minimun erase space
// This function erases the sector which is in "direccion"

void NVM_Erase_Page (unsigned int direccion) 
{
  
  unsigned char *destino;

  destino = (unsigned char *) direccion;
  
 // DisableInterrupts;
  
  if (FSTAT_FACCERR == 1 || FSTAT_FPVIOL == 1)        //Verifying error flags
  {
    FSTAT_FACCERR = 1;                                //Clear error flags
    FSTAT_FPVIOL = 1;
  }

  *destino = 0x55;
  FCMD = Page_Erase;                                  //Byte program command
  FSTAT_FCBEF = 1;                                    //Run the command 
  
   asm (NOP);
   asm (NOP);
   asm (NOP);   
   asm (NOP);
    
  
  if (FSTAT_FACCERR == 1 || FSTAT_FPVIOL == 1)        //Verifying error flags
  {
    FSTAT_FACCERR = 1;                                //Clear error flags
    FSTAT_FPVIOL = 1;
  }
  
  while (FSTAT_FCCF == 0){};
//  EnableInterrupts; 
}
