/*
 - MC51EM256Demo
   
  
  SW1 PTE1
  SW2 PTE2
  SW3 PTB6
  SW4 PTB7
  
  
  LED1  PTA5
  LED2  PTA6
  LED3  PTE4
  LED4  PTE5
  
  

 
*/


#include "m51em256evb.h" /* include peripheral declarations */
#include "stdlib.h"
#include "lcd.h"
#include "task_mgr.h"
#include "ADC16.h"





/*
   ADC  variables
*/
void ADC_start_conversions(void) ;
unsigned int ADC_results[10];



                                  

/*
   Task variables
   
*/

unsigned long timer_task;   // timer runs 1 msec


unsigned char LCD_buffer[10];  // timer runs 1 msec

/*
 memory for pushbuttons click detect 
*/
unsigned char memory_sw1;
unsigned char memory_sw2;
unsigned char memory_sw3;
unsigned char memory_sw4;



void MCU_init(void);
void time_service_1sec(void);
void time_service_1msec(void);
void RTC_init();
void GPIO_init(void);


/*
  Configure Push-buttons inputs
*/

void MCU_init(void) 
 {
  SOPT1 = 0; // Disable COP
 }


void GPIO_init(void) 
 {
  SW1_PE = 1;
  SW2_PE = 1;
  SW3_PE = 1;
  SW4_PE = 1;

  LED1_DD = 1;
  LED2_DD = 1;
  LED3_DD = 1;
  LED4_DD = 1;
  
  LED1_ON();
  LED2_ON();
  LED3_ON();
  LED4_ON();
 }



/*

  returns 1  if  input change from zero to one, otherwise returns 0
*/                                                                      

unsigned short on_rise (unsigned char input,unsigned char *memory) 
 {
 unsigned short result=0;
 if (input && *memory==0) result = 1;
 *memory = input;
 return result;
 }

#define SW1_CLICK()   on_rise(SW1_ON(),&memory_sw1)
#define SW2_CLICK()   on_rise(SW2_ON(),&memory_sw2)
#define SW3_CLICK()   on_rise(SW3_ON(),&memory_sw3)
#define SW4_CLICK()   on_rise(SW4_ON(),&memory_sw4)






/******************************************************************
    RTC init
 ****************************************************************/

void RTC_init()
{
  uint16 status;
  
 // RTC WP disable   // just for reference 
  if (RTC_CTRL_WE==2) status = 1; 

  RTC_CTRL = 0;//0b00;
  RTC_CTRL = 1;//0b01;
  RTC_CTRL = 3;//0b11;
  RTC_CTRL = 2;//0b10;
   
  if (RTC_CTRL_WE==2) status = 2; 

// RTC - Disable All RTC interrupts inlcuding tamper    
  RTC_IER = 0;  
  
  RTC_CTRL = 15<<9;  // maximum Tamper duration

  
  
  RTC_YEARMON_bin_YEAR     =  (char)(2112-2008);
  RTC_YEARMON_bin_MONTH    =  9;
  RTC_DAYS_bin_DAYS        = 27;
  RTC_HOURMIN_bin_HOURS    = 12;
  RTC_HOURMIN_bin_MINUTES  =  0;
  RTC_SECONDS_bin          =  0;

  
  RTC_CTRL |=  0x02;   // Enable Write protect   
}









/******************************************************************
    Tasks   or LCD functions
             
    
 ****************************************************************/
  

void tsk_welcome(void);
void tsk_show_time(void);
void tsk_show_date(void);
void tsk_show_lcd_blink(void);
void tsk_show_lcd_contrast(void);   //This function is not controlling the Constrat yet!!!!
void tsk_show_adc(void); 
void tsk_show_rtc_date(void);

 

void tsk_welcome(void) 
 {
   vfnLCD_Write_New_Msg("MC51EM256");
   if (SW1_CLICK() || timer_task_expires()) next_task_t(tsk_show_time,30000);
   
 }


/*
  Displays: t[hour] [minutes] [seconds]
*/


void tsk_show_time(void) 
 {
  sprintf(&LCD_buffer[0],"h%002i-%002i-%002i",RTC_HOURMIN_bin_HOURS,RTC_HOURMIN_bin_MINUTES,RTC_SECONDS_bin_SECONDS);
  vfnLCD_Write_New_Msg(&LCD_buffer[0]);
  if (SW1_CLICK() || timer_task_expires() ) next_task_t(tsk_show_date,30000);
  if (SW4_CLICK()) next_task_t(tsk_show_time,30000);

 }
 
 
/*
  Displays: d[day] [month] [year]
*/


void tsk_show_date(void) 
 {
   int year;
   year =  (int)2112 - (int)RTC_YEARMON_bin_YEAR;
   year -= 2000;  // just last digits of the year
   
   sprintf(&LCD_buffer[0],"d%002i-%002i-%002i",RTC_DAYS_bin_DAYS,RTC_YEARMON_bin_MONTH,year);
   vfnLCD_Write_New_Msg(&LCD_buffer[0]);
  if (SW1_CLICK() || timer_task_expires() ) next_task_t(tsk_show_lcd_blink,10000);
 }



/*
   Blink Rate = [N]
   
   N = 0-7 Blink rate  de .1 - 7 sec
   
   SW2 Blink rate++
   SW2 Blick rate--
   
   
*/

void tsk_show_lcd_blink(void) 
  {
   sprintf(&LCD_buffer[0],"BlinkR=%i",LCDBCTL_BRATE);
   vfnLCD_Write_New_Msg(&LCD_buffer[0]);
   LCDBCTL_BLINK = 1;
   
   if (SW2_CLICK()) 
    {
      LCDBCTL_BRATE++;
      timer_task = 10000;
    }
    
    
   if (SW3_CLICK()) 
    {
     LCDBCTL_BRATE--;timer_task = 10000;
    }


   if (SW1_CLICK() || timer_task_expires()) 
    {
     next_task_t(tsk_show_adc,30000);
     LCDBCTL_BLINK = 0;
    }


   }
   


/*
 tsk_show_lcd_contrast  Not enabled

*/   


void tsk_show_lcd_contrast(void) 
  {
   sprintf(&LCD_buffer[0],"Contr=%002i ",LCDRVC_RVTRIM);
   vfnLCD_Write_New_Msg(&LCD_buffer[0]);
   if (SW2_CLICK()) 
    {
      LCDRVC_RVTRIM++;
      timer_task = 10000;
    }
    
    
   if (SW3_CLICK()) 
    {
     LCDRVC_RVTRIM--;timer_task = 10000;
    }

   if (SW1_CLICK() || timer_task_expires()) 
    {
     next_task_t(tsk_show_date,5000);
    }

   }




/*

 Displays =  A[Chanel][Mode] Val Hex
 
 Channel 0-5
 Mode
    0 8  bits
    1 12 bits
    2 10 bits
    3 16 bits
    
  SW2  channel++
  SW3  channel--  
  SW4  Mode++

*/


void tsk_show_adc(void) 
  {
  
   static char ch=0;
   
   
   sprintf(&LCD_buffer[0],"A%i%i=%4x",ch,ADC1CFG1_MODE,ADC_results[ch]);
   vfnLCD_Write_New_Msg(&LCD_buffer[0]);
   if (SW2_CLICK()) 
    {
     ch++;
     if (ch>5) ch=0;
     timer_task=30000;
    }
    
    
   if (SW3_CLICK()) 
    {
     ch--;
     if (ch<0) ch=5;
     timer_task=30000;
    }

  if (SW4_CLICK()) 
   {
    ADC1CFG1_MODE++;
    ADC2CFG1_MODE++;
    ADC3CFG1_MODE++;
    ADC4CFG1_MODE++;
    timer_task=30000;
   }



   if (SW1_CLICK() || timer_task_expires()) 
    {
     next_task_t(tsk_show_time,15000);
    }

   }



/************************************************************
*
*  MTIM and time services
*
/************************************************************/


/*

  This routines is executed every 1msec.  In this case is called for the MTIM1 service

*/

unsigned int  time_to_sec=500;
extern  unsigned long timer_task;


void time_service_1msec(void)
 {
  
  if (timer_task) timer_task--;
  
  if (time_to_sec) time_to_sec--;
  else 
   {
   time_to_sec = 500;
   time_service_1sec();
   }
 }
  

void time_service_1sec(void)
 {
   ADC_start_conversions();  //initiates a new ADC conversion
 
 }
  





/************************************************************
     MTIM  initialization and MTIN interrupt service
*************************************************************/

#define  MTIM_CLK_DIV_1              0
#define  MTIM_CLK_DIV_2              1
#define  MTIM_CLK_DIV_4              2
#define  MTIM_CLK_DIV_8              3
#define  MTIM_CLK_DIV_16             4
#define  MTIM_CLK_DIV_32             5
#define  MTIM_CLK_DIV_64             6
#define  MTIM_CLK_DIV_128            7
#define  MTIM_CLK_DIV_256            8

#define  MTIM_CLKS_BUSCLK            0
#define  MTIM_CLKS_XCLK              1
#define  MTIM_CLKS_TCLK_FALLING      2
#define  MTIM_CLKS_TCLK_RISING       3


/*
  configure MTIM to work at 1msec usign a busclock = 4MHz
*/

void MTIM_init(void) 
 {
     MTIM1MOD = 250;
     MTIM1CLK = (MTIM_CLKS_BUSCLK<<4)  |  MTIM_CLK_DIV_16; ;  //BUSCLK , prescaler = 1
     MTIM1SC  = MTIM1SC_TOIE_MASK;//enable MTIM interrupts and Start timer operation.
 }



interrupt VectorNumber_Vmtim1 void MTIM_isrv(void) 
 {
 (void)MTIM1SC;
  MTIM1SC_TOF = 0;  // Clears TOF 
  LED1_TOGGLE();
  time_service_1msec();
 }










/*******************************************************************************
   ADC aplication 
               result offset
   ADC3 CH4    -  0
   ADC1 CH5       1
   ADC2 CH6       2
   ADC3 CH6       3
   ADC1 CH0       4
   ADC2 CH2       5


 A[Channel][Mode]0xVal 
 Channel 
 Mode  
   0   8 bits 
   1  12 bits
   2  10 bits
   3  16 bits
 
 *******************************************************************************/

unsigned char adc1_index;
unsigned char adc2_index;
unsigned char adc3_index;


/*    Configure what channels will be read by the ADC converters 
    [Result offset, Channel]
    
*/
    

const unsigned char  ADC1_CH_SEL[3][2]=
 {
  1,    5,
  4,    1,
  0xff,0x1f
 };


const unsigned char  ADC2_CH_SEL[3][2]=
 {
  2,   6,
  5,   2,
  0xff, 0x1f
 };
 


const unsigned char  ADC3_CH_SEL[3][2]=
 {
  0   ,  4,
  3   ,  0,
  0xff,0x1f
 };
 
 
 






 /*******************************************************************************
 * Interrupt:       ADC_start_conversions
 *
 * Description:     Initiates ADC1, ADC2 and ADC3 conversions
 *
 * Returns:         None
 *
 * Notes:
 *
 *******************************************************************************/



void ADC_start_conversions(void) 
 {

  adc1_index=0;
  adc2_index=0;
  adc3_index=0;
  ADCPointer = (tADC *)ADC1;
  ADCPointer->ADCSC1A.Bits.ADCHA = ADC1_CH_SEL[0][1]; 
  
  ADCPointer = (tADC *)ADC2;
  ADCPointer->ADCSC1A.Bits.ADCHA = ADC2_CH_SEL[0][1];
  
  ADCPointer = (tADC *)ADC3;
  ADCPointer->ADCSC1A.Bits.ADCHA = ADC3_CH_SEL[0][1];
 }



 /*******************************************************************************
 * Interrupt:       ADC1_init
 *
 * Description:     Prepare ADC1, ADC2 and ADC3
 *
 * Returns:         None
 *
 * Notes:
 *
 *******************************************************************************/
  
void ADC_init() {

  

  ADCPointer = (tADC *)ADC1;
  
  
  ADC_Init(ADCPointer, (ADLPC_NORMAL|ADIV_8|ADLSMP_SHORT|MODE_8|ADICLK_BUS_2), (ADACKEN_ENABLED|ADHSC_HISPEED|ADLSTS_2) , 0, 0,
  (ADTRG_SW|ACFE_DISABLED|ACFGT_LESS|ACREN_DISABLED|REFSEL_EXT), (ADCO_SINGLE|AVGE_ENABLED|AVGS_4), (AIEN_OFF|DIFF_SINGLE|0x1F),
  (AIEN_OFF|DIFF_SINGLE|0x1F));
  
  ADC_Cal(ADCPointer);
  
  ADCPointer->ADCSC1A.Bits.AIENA = 1;
 


  ADCPointer = (tADC *)ADC2;
  ADC_Init(ADCPointer, (ADLPC_NORMAL|ADIV_8|ADLSMP_SHORT|MODE_8|ADICLK_BUS_2), (ADACKEN_ENABLED|ADHSC_HISPEED|ADLSTS_2) , 0, 0,
  (ADTRG_SW|ACFE_DISABLED|ACFGT_LESS|ACREN_DISABLED|REFSEL_EXT), (ADCO_SINGLE|AVGE_ENABLED|AVGS_4), (AIEN_OFF|DIFF_SINGLE|0x1F),
  (AIEN_OFF|DIFF_SINGLE|0x1F));
  
   ADC_Cal(ADCPointer);
   
   ADCPointer->ADCSC1A.Bits.AIENA = 1;
   


  ADCPointer = (tADC *)ADC3;
  ADC_Init(ADCPointer, (ADLPC_NORMAL|ADIV_8|ADLSMP_SHORT|MODE_8|ADICLK_BUS_2), (ADACKEN_ENABLED|ADHSC_HISPEED|ADLSTS_2) , 0, 0,
  (ADTRG_SW|ACFE_DISABLED|ACFGT_LESS|ACREN_DISABLED|REFSEL_EXT), (ADCO_SINGLE|AVGE_ENABLED|AVGS_4), (AIEN_OFF|DIFF_SINGLE|0x1F),
  (AIEN_OFF|DIFF_SINGLE|0x1F));
  
   ADC_Cal(ADCPointer);
   
   ADCPointer->ADCSC1A.Bits.AIENA = 1;
   
  
//   while (ADCPointer->ADCSC2.Bits.ADACT == 1)

  
 }
 
 
 /*******************************************************************************
 * Interrupt:       ADC1_ISR
 *
 * Description:     ADC1 interrupt handler
 *
 * Returns:         None
 *
 * Notes:
 *
 *******************************************************************************/
interrupt VectorNumber_Vadc1 void ADC1_ISR (void)
 {
 
  unsigned char result_offset;
 
  ADCPointer = (tADC *)ADC1;

  result_offset = ADC1_CH_SEL[0][adc1_index++];
  ADC_results[result_offset] = ADC1RA;
  ADCPointer->ADCSC1A.Bits.ADCHA = ADC1_CH_SEL[adc1_index][1];   //start new conversion // or disable module
 
 }

/*******************************************************************************
 * Interrupt:       ADC2_ISR
 *
 * Description:     ADC1 interrupt handler
 *
 * Returns:         None
 *
 * Notes:
 *
 *******************************************************************************/
interrupt VectorNumber_Vadc2 void ADC2_ISR (void)
{
  unsigned char result_offset;
  
  ADCPointer = (tADC *)ADC2;
 
  result_offset = ADC2_CH_SEL[0][adc2_index++];
  ADC_results[result_offset] = ADC2RA;
  ADCPointer->ADCSC1A.Bits.ADCHA = ADC2_CH_SEL[adc2_index][1];   //start new conversion
 

 
}

/*******************************************************************************
 * Interrupt:       ADC3_ISR
 *
 * Description:     ADC1 interrupt handler
 *
 * Returns:         None
 *
 * Notes:
 *
 *******************************************************************************/
interrupt VectorNumber_Vadc3 void ADC3_ISR (void)
{

  unsigned char result_offset;
  
  ADCPointer = (tADC *)ADC3;
  
  result_offset = ADC3_CH_SEL[0][adc3_index++];
  ADC_results[result_offset] = ADC3RA;
  ADCPointer->ADCSC1A.Bits.ADCHA = ADC1_CH_SEL[adc3_index][1];   //start new conversion

}


 


   
/************************************************************
     main()  Demo application
*************************************************************/

void main(void) 
{
  MCU_init(); 
  RTC_init();   //RTC init
  MTIM_init();  // 1msec Base time 
  
  uart_init();     //SCI2 is used for printf.
  
  GPIO_init();
  vfnLCD_Init();

  printf("MC51EM256 Demo software");  // Send mesage via SCI1
  vfnLCD_Write_New_Msg("Hello!!!");
  next_task_t(tsk_welcome,3000);
  
  ADC_init();
  
  
  EnableInterrupts;
  
  for(;;) 
   {
    ptr_next_task();  // do the actual function:  What message is displayed
   }
}  
