/************************************************************
  DEMOEM IR demonstration software - file: main.c
************************************************************/

#include "m51em256demo.h" /* include peripheral declarations */
#include "stdlib.h"
#include "lcd.h"
#include "task_mgr.h"
#include "tpm.h"
#include "infrared.h"
#include "com_protocol.h"
#include "ascii.h"
                                 
/*** Task variables ***/
void (*ptr_next_task)(void);   /*task pointer */
UINT32 timer_task;             /* timer runs 1 msec */
UINT8 LCD_buffer[10];          

/*** memory for pushbuttons click detect ***/
UINT8 memory_sw1;
UINT8 memory_sw2;
UINT8 memory_sw3;
UINT8 memory_sw4; 

/***push button services ***/
UINT16 on_rise (unsigned char input,unsigned char *memory);
#define SW1_CLICK()   on_rise(SW1_ON(),&memory_sw1)
#define SW2_CLICK()   on_rise(SW2_ON(),&memory_sw2)
#define SW3_CLICK()   on_rise(SW3_ON(),&memory_sw3)
#define SW4_CLICK()   on_rise(SW4_ON(),&memory_sw4)

/***Initialization prototypes ***/
void vfnMCU_init(void);
void vfnGPIO_init(void);
void vfnMTIM_init(void);

/*** Main Loop Tasks prototypes ***/
void vfnTSK_welcome(void);
void vfnTSK_show_change_br(void);
void vfnTSK_show_ir(void); 
void vfnTSK_show_tx_irda(void);
void vfnTSK_protocol_welcome(void);
void vfnTSK_comm_protocol(void);
 

/*** Global variables used ***/
const UINT16 t_baud_rate[]=
   {
    300,
    600,
    1200,
    2400,
    4800,
    9600,
    19200
   };
 
static INT8 BRpointer = 0;

/************************************************************
     main()  Demo application
*************************************************************/

void main(void) 
{
  vfnMCU_init();      
  vfnMTIM_init();        /* 1msec Base time 0 */  
  vfnGPIO_init();
  vfnLCD_Init();
  vfnTPM_init();
  FlashInit();           /*Configures the Flash clock for erase and program operations*/ 
    
  if (u8SCI_init(USED_PORT, 300, DATA_LENGTH_EIGTH, PARITY_NONE, (IR_ACTIVE+1), RX_NOT_INVERTED)) for(;;){};
  if (u8IR_TX_init(USED_PORT, TX_PIN_OPTION_DEFAULT, DRIVE_STRENGTH_DISABLED, MODULATION_DISABLED, TX_INTERRUPT_DISABLED)) for(;;){};
  if (u8IR_RX_init(USED_PORT, RX_PIN_OPTION_DEFAULT, (REFERENCE_LEVEL*IR_ACTIVE), RX_INTERRUPT_ENABLED)) for(;;){};
  
  next_task_t(vfnTSK_welcome,3000);
  
  EnableInterrupts;
  
  for(;;) 
   {
    ptr_next_task();  /* do the actual function:  What message is displayed */
   }
}

//**********************Main End*****************************/

/******************************************************************
    Tasks   or LCD functions - Called in main by ptr_next_task() pointer
    in a round robin.
 ******************************************************************/

/*----------------------------------------------------------------------------------------------*/ 

void vfnTSK_welcome(void) 
 {
   vfnLCD_Write_New_Msg("IR demoEM");       
   if (SW1_CLICK() || timer_task_expires()) next_task_t(vfnTSK_show_change_br, 3000);
 }

/*----------------------------------------------------------------------------------------------*/

void vfnTSK_show_change_br(void)
{
  if(u8Set_baudrate(USED_PORT, t_baud_rate[BRpointer])) for(;;){}; 
  /*if for occurs, there was error*/
  
  if (SIMIPS2_MODTX1 && TPMMOD ==208)
  {
     next_task_t(vfnTSK_show_ir, 0); 	
  }

  if(!SIMIPS2_MODTX1)
  {
    sprintf(&LCD_buffer[0],"BR  %i",t_baud_rate[BRpointer]);
  }
   
  else
  {
    sprintf(&LCD_buffer[0],"BRM %i",t_baud_rate[BRpointer]);
  }
   
  vfnLCD_Write_New_Msg(&LCD_buffer[0]);    

  if (SW2_CLICK()) 
  {
    BRpointer++;
    if(BRpointer > 6) 
      {
        BRpointer=0;
      }
    if(u8Set_baudrate(USED_PORT, t_baud_rate[BRpointer])) for(;;){};   	
    /*if for occurs, there was error*/
  }
    
  if (SW3_CLICK()) 
  {
    BRpointer--;
    if(BRpointer < 0) BRpointer = 6;
    if(u8Set_baudrate(1, t_baud_rate[BRpointer])) for(;;){};
    /*if for occurs, there was error*/
  }
        
  if (SW4_CLICK())
  {
    if(!SIMIPS2_MODTX1)
    {
      vfnEnable_modIR();
    }
      else 
    {
      vfnDisable_modulation(); 
    }
  }
    
  if (timer_task_expires()) 
    {
      timer_task = 100;
      SCI1C2_RE = 0;
      if (SCI1S1_TDRE) 
      {
        SCI1D = 0x41;               /* Send a character by SCI1 */ 
      }
      SCI1C2_TCIE = 1; 
    }
    
    if (SW1_CLICK()) 
    {
      next_task_t(vfnTSK_show_ir, 0); 	
    }
    
  }

/*----------------------------------------------------------------------------------------------*/

 void vfnTSK_show_ir(void) 
 {
  static unsigned char ch1=0x55;
  sprintf(&LCD_buffer[0],"T%xR%x s%x",ch1,received, PTBDS_PTBDS3);
  LCD_buffer[9] =0;
  vfnLCD_Write_New_Msg(&LCD_buffer[0]);
  u8SCI_Receivechar(1,&received); // port 1,2,3
  
  if (SW2_CLICK()) 
   {
     ch1++;
    timer_task = 0;
   }
  
   if (SW3_CLICK()) 
   {
     timer_task = 0;
      ch1--;
   }
    
   if (timer_task_expires() && (SW2_ON() || SW3_ON())) 
   {
     timer_task = 100;
     SCI1C2_RE = 0;
     if (SCI1S1_TDRE) SCI1D = ch1;               /* Send a character by SCI */
     SCI1C2_TCIE = 1; 
   }
       
   if (SW4_CLICK()) 
   {
     if (u8drive_strength_set(1, TX_PIN_OPTION_DEFAULT, DRIVE_STRENGTH_TOGGLE)) for(;;){}; 
   }
    
   if (SW1_CLICK()) 
   {
     next_task_t(vfnTSK_show_tx_irda, 100);
   }
    
 }
                      
/*----------------------------------------------------------------------------------------------*/
   
  void vfnTSK_show_tx_irda(void)
  {
   
   if(!SIMIPS2_MODTX1 || TPMMOD != 208)
   {
    sprintf(&LCD_buffer[0],"IrDA OFF ");
    if (SW4_CLICK()) 
     {
       BRpointer = 5;
       if(u8Set_baudrate(1, t_baud_rate[BRpointer])) for(;;){};
       /*if for occurs, there was error*/
       vfnEnable_IrDA(); 	
     }
   }
   
   else
   {
     sprintf(&LCD_buffer[0],"IrDA ON  ");
      
     if (timer_task_expires()) 
      {
        timer_task = 100;
        SCI1C2_RE = 0;
        if (SCI1S1_TDRE) 
        {
          SCI1D = 0x41;               /*Send a character by SCI*/
        }
        SCI1C2_TCIE = 1; 
      }
     if (SW4_CLICK()) 
     {
      vfnDisable_modulation();
     }
   }
   
   vfnLCD_Write_New_Msg(&LCD_buffer[0]);
   
   if (SW1_CLICK()) 
   {
      next_task_t(vfnTSK_protocol_welcome, 0); 	
      timer_task = 0;
   }
   
  }

/*----------------------------------------------------------------------------------------------*/

void vfnTSK_protocol_welcome(void) 
 {
   vfnLCD_Write_New_Msg("Protocol");
   vfnSCI_SendMsg(USED_PORT,"Protocol");
   sendCR();        
   next_task_t(vfnTSK_comm_protocol, 3000);
 }

/*----------------------------------------------------------------------------------------------*/

void vfnTSK_comm_protocol(void)
{ 
  communication_protocol();
  
  if(LED4)
  {
    timer_task = 250;  
  } 
                 
  if (timer_task_expires()) 
  {
    LED4_OFF();
    timer_task = 500;   
  }
  
  if (SW1_CLICK()) 
  {
    LED4_OFF();	
    next_task_t(vfnTSK_show_change_br, 3000);
  }
}

/*----------------------------------------------------------------------------------------------*/
   
/********************* Tasks End******************/


/******************************************************************
    MCU and GPIO initialization
 ****************************************************************/
/*
  Configure Push-buttons inputs
*/
void vfnMCU_init(void) 
 {
  SOPT1 = 0;   /* Disable COP */
 }

void vfnGPIO_init(void) 
 {
  SW1_PE = 1;
  SW2_PE = 1;
  SW3_PE = 1;
  SW4_PE = 1;

  LED1_DD = 1;
  LED2_DD = 1;
  LED3_DD = 1;
  LED4_DD = 1;
  
  LED1_OFF();
  LED2_OFF();
  LED3_OFF();
  LED4_OFF();
 }

/*
  returns 1  if  input change from zero to one, otherwise returns 0
*/                                                                      

UINT16 on_rise (unsigned char input,unsigned char *memory) 
 {
 UINT16 result=0;
 if (input && *memory==0) result = 1;
 *memory = input;
 return result;
 }
 

/************************************************************
*
*  MTIM and time services
*
/************************************************************/

/*

  This routine is executed every 1msec.  In this case is called for the MTIM1 service

*/

UINT16  time_to_sec=500;
extern  UINT32 timer_task;

void time_service_1msec(void)
 {
  
  if (timer_task) timer_task--;
  
  if (time_to_sec) time_to_sec--;
  else 
   {
   time_to_sec = 500;
   }
 }


/************************************************************
     MTIM  initialization and MTIN interrupt service
*************************************************************/

#define  MTIM_CLK_DIV_1              0
#define  MTIM_CLK_DIV_2              1
#define  MTIM_CLK_DIV_4              2
#define  MTIM_CLK_DIV_8              3
#define  MTIM_CLK_DIV_16             4
#define  MTIM_CLK_DIV_32             5
#define  MTIM_CLK_DIV_64             6
#define  MTIM_CLK_DIV_128            7
#define  MTIM_CLK_DIV_256            8

#define  MTIM_CLKS_BUSCLK            0
#define  MTIM_CLKS_XCLK              1
#define  MTIM_CLKS_TCLK_FALLING      2
#define  MTIM_CLKS_TCLK_RISING       3

/*
  configure MTIM to work at 1msec usign a busclock = 4MHz
*/

void vfnMTIM_init(void) 
 {
    MTIM1MOD = 250;
    MTIM1CLK = (MTIM_CLKS_BUSCLK<<4) | MTIM_CLK_DIV_16;  //BUSCLK , prescaler = 1
    MTIM1SC  = MTIM1SC_TOIE_MASK;     //enable MTIM interrupts and Start timer operation.
 }


interrupt VectorNumber_Vmtim1 void MTIM_isrv(void) 
 {
 (void)MTIM1SC;
  MTIM1SC_TOF = 0;  // Clears TOF 
  LED1_TOGGLE();
  time_service_1msec();
 }
 
void interrupt VectorNumber_Vsci1tx  SCI1_tx_srvc(void) 
 {
   SCI1C2_TCIE = 0;  // Disable interrupt
   SCI1C2_RE = 1;    // enables the reception again
 }
 
