/***************** tpm.c ************/

#include "tpm.h"
#include "m51em256demo.h"

void vfnTPM_init(void)
{
  SCGC4_TPM = 1;                /*clock source to tpm enabled*/
  TPMSC_CPWMS = 1;
  TPMC0SC = TPMC0SC_ELS0B_MASK;  
  SIMIPS2_MTBASE1 = 0;          /*two bits.0 for modulation with TPM ch0 */
  TPMSC_CLKSB = 0;
  TPMSC_CLKSA = 1;
}


/***** MODULATION AT 38KHz *****/

void vfnEnable_modIR(void) 
{
  TPMC0V = 27; 
  TPMMOD = 54;
  if (u8modulation_set(1, 1)) for(;;){};   
}

/***** MODULATION AS IrDA *****/

void vfnEnable_IrDA(void)
{
  TPMC0V = 39;
  TPMMOD = 208;
  if (u8modulation_set(1, 1)) for(;;){};   
}


void vfnDisable_modulation(void)
{
  if (u8modulation_set(1, 0)) for(;;){};
  TPMC0V = 27; 
  TPMMOD = 54;
}
