/*
 * File:    startup.c
 * Purpose: Generic application startup code
 *
 * Notes:   
 */

#include "m51em256demo.h" /* include peripheral declarations */

void common_startup(void);			//FSL: added function prototype

/********************************************************************/
void
common_startup(void)
{
    extern char __DATA_ROM[];
    extern char __DATA_RAM[];
    extern char __DATA_END[];
    extern char __BSS_START[];
    extern char __BSS_END[];
    extern UINT32 VECTOR_TABLE[];
    extern UINT32 __VECTOR_RAM[];
    register UINT32 n;
    register UINT8 *dp, *sp;

    /* 
     * Copy the vector table to RAM 
     */
    if (__VECTOR_RAM != VECTOR_TABLE)
    {
        for (n = 0; n < 256; n++)
            __VECTOR_RAM[n] = VECTOR_TABLE[n];
    }
    mcf5xxx_wr_vbr((UINT32)__VECTOR_RAM);

    /* 
     * Move initialized data from ROM to RAM. 
     */
    if (__DATA_ROM != __DATA_RAM)
    {
        dp = (UINT8 *)__DATA_RAM;
        sp = (UINT8 *)__DATA_ROM;
        n = __DATA_END - __DATA_RAM;
        while (n--)
            *dp++ = *sp++;
    }
 
    /* 
     * Zero uninitialized data 
     */
    if (__BSS_START != __BSS_END)
    {
        sp = (UINT8 *)__BSS_START;
        n = __BSS_END - __BSS_START;
        while (n--)
            *sp++ = 0;
    }
}

/********************************************************************/
