#include "m51em256evb.h"
#include "sci.h"
#include "kbi.h"
#include "low_power.h"

#include "validation.h"

#ifdef SCI_TEST10         

/*
          
            
*/


unsigned char rx_data;
unsigned char SPI_rx_data;

unsigned char ReceivedData1;

/*This function are called by the KBI interrupt */

void sw_301_click(void)  //PTD4
  {

    switch(PORT_SELECTED)
    {
      //SCI functions
      case 1:
           SCI1C1_SCISWAI  = 0;      //disable wait
        break;
        
      case 2:
           SCI2C1_SCISWAI  = 0;      //disable wait
        break;
        
      case 3:
           SCI3C1_SCISWAI  = 0;      //disable wait
        break;
        
      default:
        for(;;)
        ; //error
        break;
    }   
  }
   
 void sw_302_click(void)  //PTD5
  {
      _Wait;
  }

void sw_303_click(void)  //PTD6
  {
    switch(PORT_SELECTED)
    {
      //SCI functions
      case 1:
           SCI1C1_SCISWAI  = 1;      //disable wait
        break;
        
      case 2:
           SCI2C1_SCISWAI  = 1;      //disable wait    
        break;
        
      case 3:                
           SCI3C1_SCISWAI  = 1;      //disable wait      
        break;
        
      default:
        for(;;)
        ; //error
        break;
    }      
  }

void sw_304_click(void)  //PTD7
  {
      _Wait;
  }

void interrupt VectorNumber_Vsci1rx SCI1_isrv() 
{
   unsigned char status;
   status=SCI1S1;
   ReceivedData1 = SCI1D;   
}

void interrupt VectorNumber_Vsci2rx SCI2_isrv() 
{
   unsigned char status;
   status=SCI2S1;
   ReceivedData1 = SCI2D; 
}

void interrupt VectorNumber_Vsci3rx SCI3_isrv() 
{
   unsigned char status;
   status=SCI3S1;
   ReceivedData1 = SCI3D; 
}

void sci_test10(void) 
{
//low power init: START
  
  low_power_init(WAIT);//mcu start
                                                                    
  pinout_init();//all pins as: output, low level = pull-up = filter = strength = 0
  
  disable_all_clocks();  
  
  clock_init_32KHz_lp();//50MHz
//low power init: END  


  SCGC3_PTE = 1;//KBI port  

  SCI_init(PORT_SELECTED,BR_19200);

    switch(PORT_SELECTED)
    {
      //SCI functions
      case 1:
            //                      
           SCI1C2_RIE = 1; 
        break;
        
      case 2:
           SCI2C2_RIE = 1;    
        break;
        
      case 3:
           SCI3C2_RIE = 1;       
        break;
        
      default:
        for(;;)
        ; //error
        break;
    }

  EnableInterrupts; /* enable interrupts */

  KBI1_init();
  
  delay_init();
  
  for(;;) 
  {
    switch(PORT_SELECTED)
    {
      //SCI functions
      case 1:
        if(SCI1C1_SCISWAI)
        {
           SCI_SendMsg(PORT_SELECTED,"SCI WAIT OFF\t");
        }
        else
        {
           SCI_SendMsg(PORT_SELECTED,"SCI WAIT ON\t");
        } 
        break;
        
      case 2:
        if(SCI2C1_SCISWAI)
        {
           SCI_SendMsg(PORT_SELECTED,"SCI WAIT OFF\t");
        }
        else
        {
           SCI_SendMsg(PORT_SELECTED,"SCI WAIT ON\t");
        } 
   
        break;
        
      case 3:
        if(SCI3C1_SCISWAI)
        {
           SCI_SendMsg(PORT_SELECTED,"SCI WAIT OFF\t");
        }
        else
        {
           SCI_SendMsg(PORT_SELECTED,"SCI WAIT ON\t");
        } 
       
        break;
        
      default:
        for(;;)
        ; //error
        break;
    }
    
    delay_start(500);
    
    //__RESET_WATCHDOG(); /* feeds the dog */
    
  } /* loop forever */
  /* please make sure that you never leave main */

}

#endif