#include "m51em256evb.h"
#include "sci.h"
#include "kbi.h"
#include "low_power.h"

#include "validation.h"

#ifdef SCI_TEST6         

/*
see validation doc for details,              
            
*/

unsigned char ReceivedData1;
unsigned char ReceivedData2;

void SCI1_init_RIE(unsigned short br)
  {
    /*SCI function*/
    PTBPF2_B2 = 3;
    PTBPF2_B3 = 3;    

    /*starting SCI clock*/
    SCGC1_SCI1 = 1;
    
    SCI1BD = br;
    SCI1C1 = 0x00;      //start + 8 data bits (LSB first) + stop       
    SCI1C2_TE = 1;      //enable transmitter
    SCI1C2_RE = 1;      //enable transmitter
    SCI1C2_RIE = 1;
    SCI1C1_LOOPS = 1;
    SCI1C1_RSRC  = 1;  //Single Wire Operation
    SCI1C3_TXDIR = 0;   // pin as receiver
    
  }                        


void SCI2_init_RIE(unsigned short br)
  {
  
    /*SCI function*/
    PTBPF2_B0 = 3;
    PTBPF2_B1 = 3;    

    /*starting SCI clock*/
    SCGC1_SCI2 = 1;
    
    SCI2BD = br;
    SCI2C1 = 0x00;      //start + 8 data bits (LSB first) + stop       
    SCI2C2_TE = 1;      //enable transmitter
    SCI2C2_RE = 1;      //enable transmitter
    SCI2C2_RIE = 1;
    SCI2C1_LOOPS = 1;
    SCI2C1_RSRC  = 1;  //Single Wire Operation
    SCI2C3_TXDIR = 0;   // pin as receiver
    
   DISABLE_MUX_CONTROL; 
  }                        

void SCI3_init_RIE(unsigned short br)
  {
    /*SCI function*/
    PTFPF2_F2 = 3;
    PTFPF2_F3 = 3;    

    /*starting SCI clock*/
    SCGC1_SCI3 = 1;
    
    SCI3BD = br;
    SCI3C1 = 0x00;      //start + 8 data bits (LSB first) + stop       
    SCI3C2_TE = 1;      //enable transmitter
    SCI3C2_RE = 1;      //enable transmitter
    SCI3C2_RIE = 1;
    SCI3C1_LOOPS = 1;
    SCI3C1_RSRC  = 1;  //Single Wire Operation
    SCI3C3_TXDIR = 0;   // pin as receiver  
  }


void interrupt VectorNumber_Vsci1rx SCI1_isrv() 
  {
   unsigned char status;
   status=SCI1S1;
   ReceivedData1 = SCI1D; 
   LED1_TOG;
  }


void interrupt VectorNumber_Vsci2rx SCI2_isrv() 
  {
   unsigned char status;
   status=SCI2S1;
   ReceivedData2 = SCI2D;
   
   /*wait some time!!!*/
   delay_start(500); 
   LED0_TOG;
  }

void interrupt VectorNumber_Vsci3rx SCI3_isrv() 
  {
   unsigned char status;
   status=SCI3S1;
   ReceivedData2 = SCI3D; 
   //LED0_TOG;
#ifdef SINGLEWIRE_TEST1   
   LED2_TOG;
#endif
#ifdef SINGLEWIRE_TEST2
   /*wait some time!!!*/
   delay_start(500); 
   LED0_TOG;
#endif   
  }

/*This function are called by the KBI interrupt */

void sw_301_click(void)  //PTD4
  {
   #ifdef SINGLEWIRE_TEST1
     SCI1C3_TXDIR = 1; 
     SCI_SendChr(1,'1');  
     while (!SCI1S1_TC){};
     SCI1C3_TXDIR = 0;
   #endif
   #ifdef SINGLEWIRE_TEST2
     SCI2C3_TXDIR = 1; 
     SCI_SendChr(2,'2');  
     while (!SCI2S1_TC){};
     SCI2C3_TXDIR = 0;
   #endif    
  }
   
 void sw_302_click(void)  //PTD5
  {
   //always sends!!
   SCI3C3_TXDIR = 1; 
   SCI_SendChr(3,'3');  
   while (!SCI3S1_TC){};
   SCI3C3_TXDIR = 0; 
  }

void sw_303_click(void)  //PTD6
  {
   #ifdef SINGLEWIRE_TEST1
     SCI1C3_TXDIR = 1; 
     SCI_SendChr(1,'1');  
     while (!SCI1S1_TC){};
     SCI1C3_TXDIR = 0;
   #endif
   #ifdef SINGLEWIRE_TEST2
     SCI2C3_TXDIR = 1; 
     SCI_SendChr(2,'2');  
     while (!SCI2S1_TC){};
     SCI2C3_TXDIR = 0;
   #endif 
  }


void sw_304_click(void)  //PTD7
  {
   //always sends!!
   SCI3C3_TXDIR = 1; 
   SCI_SendChr(3,'3');  
   while (!SCI3S1_TC){};
   SCI3C3_TXDIR = 0; 
  }


void sci_test6(void) 
{
  
  EnableInterrupts; /* enable interrupts */
  /* include your code here */
  
  KBI1_init();
  
  #ifdef SINGLEWIRE_TEST1
        PTDPF2_D2 = 0b00;   // TXD2 pin GPIO for LED
        PTDDD_PTDDD2= 1;    // make it output
        
        PTDPF2_D3 = 0b00;   // RXD2 pin GPIO for LED
        PTDDD_PTDDD3= 1;    // make it output
        SCI1_init_RIE(BR_19200);
        SCI3_init_RIE(BR_19200);
  #endif

  #ifdef SINGLEWIRE_TEST2
       delay_init();
  
        //********remove JP12
        PTDPF2_D1 = 0b00;   // RXD1 pin GPIO for LED
        PTDDD_PTDDD1= 1;    // make it output
        SCI2_init_RIE(BR_19200);
        SCI3_init_RIE(BR_19200);
  #endif
  
  for(;;) 
  {   
    //SCI2_SendChr('2');
    //__RESET_WATCHDOG(); /* feeds the dog */
    
  } /* loop forever */
  /* please make sure that you never leave main */
}

#endif