#include "m51em256evb.h"

#include "sci.h"
#include "kbi.h"

#include "validation.h"

#ifdef SCI_TEST3         

/*
Read Lasko SCI validation doc for details...       
*/


unsigned char ReceivedData1;

void SCI_init_RIE(uint8 port, unsigned short br)
{       
    switch(port)
    {
      //SCI functions
      case 1:
          /*SCI function*/
          PTBPF2_B2 = 3;
          PTBPF2_B3 = 3;    

          /*starting SCI clock*/
          SCGC1_SCI1 = 1;
          
          SCI1BD = br;
          SCI1C1 = 0x00;      //start + 8 data bits (LSB first) + stop       
          SCI1C2_TE = 1;      //enable transmitter
          SCI1C2_RE = 1;      //enable transmitter
          SCI1C2_RIE = 1;
        break;
        
      case 2:
          /*SCI function*/
          PTBPF2_B0 = 3;
          PTBPF2_B1 = 3;    

          /*starting SCI clock*/
          SCGC1_SCI2 = 1;
          
          SCI2BD = br;
          SCI2C1 = 0x00;      //start + 8 data bits (LSB first) + stop       
          SCI2C2_TE = 1;      //enable transmitter
          SCI2C2_RE = 1;      //enable transmitter
          SCI2C2_RIE = 1;    
        break;
        
      case 3:
          /*SCI function*/
          PTFPF2_F2 = 3;
          PTFPF2_F3 = 3;    

          /*starting SCI clock*/
          SCGC1_SCI3 = 1;
          
          SCI3BD = br;
          SCI3C1 = 0x00;      //start + 8 data bits (LSB first) + stop       
          SCI3C2_TE = 1;      //enable transmitter
          SCI3C2_RE = 1;      //enable transmitter
          SCI3C2_RIE = 1;      
        break;
        
      default:
        for(;;)
        ; //error
        break;
    }
}                        

void interrupt VectorNumber_Vsci1rx SCI1_isrv() 
{
   unsigned char status;
   status=SCI1S1;
   ReceivedData1 = SCI1D; 
   
   LED1_TOG;   
}

void interrupt VectorNumber_Vsci2rx SCI2_isrv() 
{
   unsigned char status;
   status=SCI2S1;
   ReceivedData1 = SCI2D; 
   
   LED0_TOG;
}

void interrupt VectorNumber_Vsci3rx SCI3_isrv() 
{
   unsigned char status;
   status=SCI3S1;
   ReceivedData1 = SCI3D; 
   
   LED2_TOG;   
}

/*This function are called by the KBI interrupt */

void sw_301_click(void)
{
    switch(PORT_SELECTED)
    {
      //SCI functions
      case 1:
             SCI1C1_LOOPS = 0;
             SCI1C1_RSRC  = 0;  //SCI do use RXD pin
        break;
        
      case 2:
             SCI2C1_LOOPS = 0;
             SCI2C1_RSRC  = 0;  //SCI do use RXD pin     
        break;
        
      case 3:
             SCI3C1_LOOPS = 0;
             SCI3C1_RSRC  = 0;  //SCI do use RXD pin     
        break;
        
      default:
        for(;;)
        ; //error
        break;
    }
}
   
 void sw_302_click(void)  //PTD5
  {
    switch(PORT_SELECTED)
    {
      //SCI functions
      case 1:
             SCI_SendChr(1,'5');
        break;
        
      case 2:
             SCI_SendChr(2,'5');     
        break;
        
      case 3:
             SCI_SendChr(3,'5');       
        break;
        
      default:
        for(;;)
        ; //error
        break;
    }
    
  }

void sw_303_click(void)  //PTD6
  {
    switch(PORT_SELECTED)
    {
      //SCI functions
      case 1:
            SCI1C1_LOOPS = 1;
            SCI1C1_RSRC  = 0;  //SCI don't use RXD pin
        break;
        
      case 2:
            SCI2C1_LOOPS = 1;
            SCI2C1_RSRC  = 0;  //SCI don't use RXD pin    
        break;
        
      case 3:
            SCI3C1_LOOPS = 1;
            SCI3C1_RSRC  = 0;  //SCI don't use RXD pin        
        break;
        
      default:
        for(;;)
        ; //error
        break;
    }   
  }  

void sw_304_click(void)  //PTD7
  {
    switch(PORT_SELECTED)
    {
      //SCI functions
      case 1:
             SCI_SendChr(PORT_SELECTED,'A');
        break;
        
      case 2:
             SCI_SendChr(PORT_SELECTED,'A');     
        break;
        
      case 3:
             SCI_SendChr(PORT_SELECTED,'A');       
        break;
        
      default:
        for(;;)
        ; //error
        break;
    }
  }

void sci_test3(void) 
{  
  EnableInterrupts; /* enable interrupts */
  /* include your code here */

  SCI_init_RIE(PORT_SELECTED,BR_19200);

  KBI1_init();
  
  for(;;) 
  {
    __RESET_WATCHDOG(); /* feeds the dog */
    
  } /* loop forever */
  /* please make sure that you never leave main */
}

#endif