#include "m51em256evb.h"
#include "sci.h"
#include "kbi.h"

#include "validation.h"

#ifdef SCI_TEST7         

/*
          
            
*/


unsigned char rx_data;
unsigned char SPI_rx_data;

unsigned char ReceivedData1;

/*This function are called by the KBI interrupt */

void sw_301_click(void)  //PTD4
  {

    switch(PORT_SELECTED)
    {
      //SCI functions
      case 1:
           SCGC1_SCI1 = 1;
           SCI1C2_TE  = 1;      //enable Transmitter and Receiver
           SCI1C2_RE  = 1;
        break;
        
      case 2:
           SCGC1_SCI2 = 1;
           SCI2C2_TE  = 1;      //enable Transmitter and Receiver
           SCI2C2_RE  = 1;    
        break;
        
      case 3:
           SCGC1_SCI3 = 1;
           SCI3C2_TE  = 1;      //enable Transmitter and Receiver
           SCI3C2_RE  = 1;       
        break;
        
      default:
        for(;;)
        ; //error
        break;
    }   
  
  }
   
 void sw_302_click(void)  //PTD5
  {
    switch(PORT_SELECTED)
    {
      //SCI functions
      case 1:
           SCGC1_SCI1 = 0;
           SCI1C2_TE  = 0;      //disable Transmitter and Receiver
           SCI1C2_RE  = 0;
        break;
        
      case 2:
           SCGC1_SCI2 = 0;
           SCI2C2_TE  = 0;      //disable Transmitter and Receiver
           SCI2C2_RE  = 0;    
        break;
        
      case 3:
           SCGC1_SCI3 = 0;
           SCI3C2_TE  = 0;      //disable Transmitter and Receiver
           SCI3C2_RE  = 0;       
        break;
        
      default:
        for(;;)
        ; //error
        break;
    }
  }

void sw_303_click(void)  //PTD6
  {

    switch(PORT_SELECTED)
    {
      //SCI functions
      case 1:
           SCGC1_SCI1 = 1;
           SCI1C2_TE  = 1;      //enable Transmitter and Receiver
           SCI1C2_RE  = 1;
        break;
        
      case 2:
           SCGC1_SCI2 = 1;
           SCI2C2_TE  = 1;      //enable Transmitter and Receiver
           SCI2C2_RE  = 1;    
        break;
        
      case 3:
           SCGC1_SCI3 = 1;
           SCI3C2_TE  = 1;      //enable Transmitter and Receiver
           SCI3C2_RE  = 1;       
        break;
        
      default:
        for(;;)
        ; //error
        break;
    }   

#if 0
/* TxPIN y RXPin must be set as output in order to don't leave any floating pin */      
   PTBDD_PTBDD0 = 1;  /*TXTX as output in order to don't leave this pin as floating input*/
   PTBDD_PTBDD1 = 1;
   PTBD_PTBD0 = 1;    /*TXRX as output */
   PTBD_PTBD1 = 1;
#endif 
  }

void sw_304_click(void)  //PTD7
  {
    switch(PORT_SELECTED)
    {
      //SCI functions
      case 1:
           SCGC1_SCI1 = 0;
           SCI1C2_TE  = 0;      //disable Transmitter and Receiver
           SCI1C2_RE  = 0;
        break;
        
      case 2:
           SCGC1_SCI2 = 0;
           SCI2C2_TE  = 0;      //disable Transmitter and Receiver
           SCI2C2_RE  = 0;    
        break;
        
      case 3:
           SCGC1_SCI3 = 0;
           SCI3C2_TE  = 0;      //disable Transmitter and Receiver
           SCI3C2_RE  = 0;       
        break;
        
      default:
        for(;;)
        ; //error
        break;
    }
  }

void interrupt VectorNumber_Vsci1rx SCI1_isrv() 
{
   unsigned char status;
   status=SCI1S1;
   ReceivedData1 = SCI1D; 
   
   LED1_TOG;   
}

void interrupt VectorNumber_Vsci2rx SCI2_isrv() 
{
   unsigned char status;
   status=SCI2S1;
   ReceivedData1 = SCI2D; 
   
   LED0_TOG;
}

void interrupt VectorNumber_Vsci3rx SCI3_isrv() 
{
   unsigned char status;
   status=SCI3S1;
   ReceivedData1 = SCI3D; 
   
   LED2_TOG;
}

void sci_test7(void) 
{
  
  EnableInterrupts; /* enable interrupts */
  /* include your code here */

  SCI_init(PORT_SELECTED,BR_19200);

    switch(PORT_SELECTED)
    {
      //SCI functions
      case 1:
            //                      
           SCI1C2_RIE = 1; 
        break;
        
      case 2:
           SCI2C2_RIE = 1;    
        break;
        
      case 3:
           SCI3C2_RIE = 1;       
        break;
        
      default:
        for(;;)
        ; //error
        break;
    }

  KBI1_init();
  
  delay_init();
  
  for(;;) 
  {
  
    SCI_SendChr(PORT_SELECTED,'A');
    
    delay_start(500);
    
    //__RESET_WATCHDOG(); /* feeds the dog */
    
  } /* loop forever */
  /* please make sure that you never leave main */
}

#endif