/*

check lasko validation doc      
            
*/

#include "m51em256evb.h"
#include "sci.h"
#include "kbi.h"
#include "tpm.h"

#include "validation.h"

#ifdef SCI_TEST4

void SCI_init_LBDTIE(unsigned short br)
{
    switch(PORT_SELECTED)
    {
      //SCI functions
      case 1:
            /*SCI function*/
            PTBPF2_B2 = 3;
            PTBPF2_B3 = 3;    

            /*starting SCI clock*/
            SCGC1_SCI1 = 1;
           
           SCI1BD = /*SCI1BD_LBKDIE_MASK | */br;
           SCI1C1 = 0x00;      //start + 8 data bits (LSB first) + stop       
           SCI1C2_TE = 1;      //enable transmitter
           SCI1C2_RE = 1;      //enable receiver
           
           SCI1C2_RIE = 1;
           
           /*error interrupts*/
           SCI1C3_ORIE = 1;
           SCI1C3_FEIE = 1;
           SCI1C3_NEIE = 1;
           SCI1C3_PEIE = 1;
           
           //SCI1C1_LOOPS = 1;/*loopback*/
        break;
        
      case 2:
            /*SCI function*/
            PTBPF2_B0 = 3;
            PTBPF2_B1 = 3;    

            /*starting SCI clock*/
            SCGC1_SCI2 = 1;
            
            SCI2BD = /*SCI2BD_LBKDIE_MASK | */br;
            SCI2C1 = 0x00;      //start + 8 data bits (LSB first) + stop       
            SCI2C2_TE = 1;      
            SCI2C2_RE = 1; 
            
            SCI2C2_RIE = 1;

           /*error interrupts*/
           SCI2C3_ORIE = 1;
           SCI2C3_FEIE = 1;
           SCI2C3_NEIE = 1;
           SCI2C3_PEIE = 1;
            
            //SCI2C1_LOOPS = 1;/*loopback*/     
        break;
        
      case 3:
            /*SCI function*/
            PTFPF2_F2 = 3;
            PTFPF2_F3 = 3;    

            /*starting SCI clock*/
            SCGC1_SCI3 = 1;       
          
            SCI3BD = /*SCI2BD_LBKDIE_MASK | */br;
            SCI3C1 = 0x00;      //start + 8 data bits (LSB first) + stop       
            SCI3C2_TE = 1;      
            SCI3C2_RE = 1; 
            
            SCI3C2_RIE = 1;

           /*error interrupts*/
           SCI3C3_ORIE = 1;
           SCI3C3_FEIE = 1;
           SCI3C3_NEIE = 1;
           SCI3C3_PEIE = 1;
            
            //SCI3C1_LOOPS = 1;/*loopback*/
        break;
        
      default:
        for(;;)
        ; //error
        break;
    }
}                                              

unsigned char rx_data;

/*These functions are called by the KBI interrupt */

/*Recieves normal data*/
void sw_301_click(void)
{
    switch(PORT_SELECTED)
    {
      //SCI functions
      case 1:
            SCI1S2_RXINV = 0;
        break;
        
      case 2:
            SCI2S2_RXINV = 0;     
        break;
        
      case 3:
            SCI3S2_RXINV = 0;       
        break;
        
      default:
        for(;;)
        ; //error
        break;
    }
}
   
/*sends normal data*/
void sw_302_click(void)
{
    switch(PORT_SELECTED)
    {
      //SCI functions
      case 1:
            SCI1C3_TXINV = 0; //Transmit Data "normal"
            SCI_SendChr(PORT_SELECTED,'A');
        break;
        
      case 2:
            SCI2C3_TXINV = 0; //Transmit Data "normal"
            SCI_SendChr(PORT_SELECTED,'2');     
        break;
        
      case 3:
            SCI3C3_TXINV = 0; //Transmit Data "normal"
            SCI_SendChr(PORT_SELECTED,'3');       
        break;
        
      default:
        for(;;)
        ; //error
        break;
    }
}

/*Recieves inverted data*/
void sw_303_click(void)
{
    switch(PORT_SELECTED)
    {
      //SCI functions
      case 1:
           SCI1S2_RXINV = 1; 
        break;
        
      case 2:
           SCI2S2_RXINV = 1;      
        break;
        
      case 3:
           SCI3S2_RXINV = 1;        
        break;
        
      default:
        for(;;)
        ; //error
        break;
    } 
}

/*sends inverted data*/
void sw_304_click(void)
{
    switch(PORT_SELECTED)
    {
      //SCI functions
      case 1:
             SCI1C3_TXINV = 1; //Transmit Data "inverted"
             SCI_SendChr(PORT_SELECTED,'A'); 
        break;
        
      case 2:
             SCI2C3_TXINV = 1; //Transmit Data "inverted"
             SCI_SendChr(PORT_SELECTED,'2');      
        break;
        
      case 3:
             SCI3C3_TXINV = 1; //Transmit Data "inverted"
             SCI_SendChr(PORT_SELECTED,'3');        
        break;
        
      default:
        for(;;)
        ; //error
        break;
    }
}
  
/**/
unsigned char ReceivedData1;

void interrupt VectorNumber_Vsci1rx SCI1_isrv() 
{
   unsigned char status;
   status=SCI1S1;
   ReceivedData1 = SCI1D;
   SCI1C3_TXINV = 0; //Transmit Data "normal"
   SCI_SendChr(PORT_SELECTED,ReceivedData1);   
}

void interrupt VectorNumber_Vsci1err SCI1err_isrv() 
{
   unsigned char status;
   if(SCI1S1_OR)
   {
     SCI1C3_TXINV = 0; //Transmit Data "normal"
     SCI_SendMsg(PORT_SELECTED,"Error: OR ");
   }
   else if(SCI1S1_NF)
   {
     SCI1C3_TXINV = 0; //Transmit Data "normal"
     SCI_SendMsg(PORT_SELECTED,"Error: NF ");
   }
   else if(SCI1S1_FE)
   {
     SCI1C3_TXINV = 0; //Transmit Data "normal"
     SCI_SendMsg(PORT_SELECTED,"Error: FE ");    
   }
   else if(SCI1S1_PF)
   {
     SCI1C3_TXINV = 0; //Transmit Data "normal"
     SCI_SendMsg(PORT_SELECTED,"Error: PF ");     
   }
   /*clear it*/
   status=SCI1S1;
   ReceivedData1 = SCI1D;
}

void interrupt VectorNumber_Vsci2rx SCI2_isrv() 
{
   unsigned char status;
   status=SCI2S1;
   ReceivedData1 = SCI2D;
   SCI1C3_TXINV = 0; //Transmit Data "normal"
   SCI_SendChr(PORT_SELECTED,ReceivedData1); ; 
}

void interrupt VectorNumber_Vsci2err SCI2err_isrv() 
{
   unsigned char status;
   if(SCI2S1_OR)
   {
     SCI2C3_TXINV = 0; //Transmit Data "normal"
     SCI_SendMsg(PORT_SELECTED,"Error: OR ");
   }
   else if(SCI2S1_NF)
   {
     SCI2C3_TXINV = 0; //Transmit Data "normal"
     SCI_SendMsg(PORT_SELECTED,"Error: NF ");
   }
   else if(SCI2S1_FE)
   {
     SCI2C3_TXINV = 0; //Transmit Data "normal"
     SCI_SendMsg(PORT_SELECTED,"Error: FE ");    
   }
   else if(SCI2S1_PF)
   {
     SCI2C3_TXINV = 0; //Transmit Data "normal"
     SCI_SendMsg(PORT_SELECTED,"Error: PF ");     
   }
   /*clear it*/
   status=SCI2S1;
   ReceivedData1 = SCI2D;
}

void interrupt VectorNumber_Vsci3rx SCI3_isrv() 
{
   unsigned char status;
   status=SCI3S1;
   ReceivedData1 = SCI3D;
   SCI1C3_TXINV = 0; //Transmit Data "normal"
   SCI_SendChr(PORT_SELECTED,ReceivedData1);  
}

void interrupt VectorNumber_Vsci3err SCI3err_isrv() 
{
   unsigned char status;
   if(SCI3S1_OR)
   {
     SCI3C3_TXINV = 0; //Transmit Data "normal"
     SCI_SendMsg(PORT_SELECTED,"Error: OR ");
   }
   else if(SCI3S1_NF)
   {
     SCI3C3_TXINV = 0; //Transmit Data "normal"
     SCI_SendMsg(PORT_SELECTED,"Error: NF ");
   }
   else if(SCI3S1_FE)
   {
     SCI3C3_TXINV = 0; //Transmit Data "normal"
     SCI_SendMsg(PORT_SELECTED,"Error: FE ");    
   }
   else if(SCI3S1_PF)
   {
     SCI3C3_TXINV = 0; //Transmit Data "normal"
     SCI_SendMsg(PORT_SELECTED,"Error: PF ");     
   }
   /*clear it*/
   status=SCI3S1;
   ReceivedData1 = SCI3D;
}

void sci_test4(void) 
{  
  EnableInterrupts; /* enable interrupts */
  /* include your code here */

  SCI_init_LBDTIE(BR_19200);

  KBI1_init();
  //delay_init();
  
  for(;;) 
  {
    //SCI_SendChr(PORT_SELECTED,'X');
    //__RESET_WATCHDOG(); /* feeds the dog */
    //delay_start(500);//wait 100 ms
  } /* loop forever */
}

#endif