#include "m51em256evb.h"

#include "sci.h"
#include "kbi.h"

#include "validation.h"

#ifdef SCI_TEST11         

/*
Read Lasko SCI validation doc for details...       
*/


/*This function are called by the KBI interrupt */

void sw_301_click(void)
{

}
   
 void sw_302_click(void)  //PTD5
  {

    
  }

void sw_303_click(void)  //PTD6
  {
   
  }  

void sw_304_click(void)  //PTD7
  {

  }

void SCI3_init_fec_pins(unsigned short br)
{
   /*SCI function: turn on SCI pins shared with FEC*/
   /*SCI function*/
   PTFPF2_F2 = 3;
   PTFPF2_F3 = 3;    

   /*starting SCI clock*/
   SCGC1_SCI3 = 1;

   SCI3BD = br;
   SCI3C1 = 0x00;      //start + 8 data bits (LSB first) + stop       
   SCI3C2_TE = 1;      //enable transmitter
   SCI3C2_RE = 1;      //enable transmitter  
}

void sci_test11(void) 
{
  uint8 data_tx = 0x55,data_rx;
  vuint8 error;
  
  EnableInterrupts; /* enable interrupts */
  /* include your code here */

  /*set FEC pins in high impedance to avoid interference with shared SCI pins*/
  fec_set_high_impedance_pins();

  /****Once pair of pins has been selected, they cannot be moved to other pair on Lasko***/
  /*ie: once working on pins located at SCI3, they won't work on FEC pins*/
  SCI3_init_fec_pins(BR_19200);

  SCI3C1_LOOPS = 1;//internal loopback

  //KBI1_init();
  delay_init();
  
  for(;;) 
  {
    error = SCI_SendChr(3,data_tx);
    error = SCI_ReceiveChar(3,&data_rx);
    
    if(data_rx == data_tx)
    {
       LED2_TOG;
    }
    
    delay_start(500);/*sending characters*/
  } /* loop forever */
  /* please make sure that you never leave main */
}

#endif