#include "m51em256evb.h"
#include "sci.h"
#include "kbi.h"
#include "tpm.h"

#include "validation.h"

#ifdef SCI_TEST9         

/*      
????           
*/

unsigned char rx_data;
unsigned char SPI_rx_data;

unsigned char ReceivedData1;

/*This function are called by the KBI interrupt */

void sw_301_click(void)  //PTD4
  {

  }
   
 void sw_302_click(void)  //PTD5
  {

  }

void sw_303_click(void)  //PTD6
  {

  }

void sw_304_click(void)  //PTD7
  {

  }

void interrupt VectorNumber_Vsci3or SCI3_isr() 
{
   vuint8 status;
   status=SCI3S1;
   
   if(status & SCI3S1_RDRF_MASK)//rx condition
   {
      ReceivedData1 = SCI3D;
      LED2_TOG;           //ack that we rx a char
   }
   else if(status & SCI3S1_TC_MASK)//tx condition
   {
      /*disable interrupt*/
      SCI3C2_TCIE = 0;
   }
   //error conditions
   else if(status & SCI3S1_OR_MASK)//overrrun
   {
      for(;;)
      ; /*infinite loop*/    
   }
   //error conditions
   else if(status & SCI3S1_FE_MASK)//frame error
   {
      for(;;)
      ; /*infinite loop*/    
   }
   //error conditions
   else if(status & SCI3S1_NF_MASK)//noise error
   {
      for(;;)
      ; /*infinite loop*/    
   }
   //error conditions
   else if(status & SCI3S1_PF_MASK)//parity error
   {
      for(;;)
      ; /*infinite loop*/    
   }      
   else//unknown condition
   {
      for(;;)
      ; /*infinite loop*/
   } 
}

void sci_test9(void) 
{
  
  EnableInterrupts; /* enable interrupts */
  /* include your code here */

  SCI_init(3,BR_19200);
  
  //refence manual is wrong about bit SCI3DO on INTC_ORMR
  INTC_ORMR &= ~(0x20);/*enabling SCI3 interrupt ORing*/
  
  /*enable rx interrupt*/
  SCI3C2_RIE = 1;

  KBI1_init();
  
  delay_init();
  
  for(;;) 
  {  
    /*enable interrupt*/
    SCI3C2_TCIE = 1;      
    
    SCI_SendChr(3,'H');
    
    delay_start(1000);//~1 sec
    
    //__RESET_WATCHDOG(); /* feeds the dog */
    
  } /* loop forever */
  /* please make sure that you never leave main */
}

#endif