/*
 * File:        uart.h
 *
 * Notes:       
 *              
 */

#ifndef __UART_H__
#define __UART_H__

/********************************************************************/
/*
 * Initialize the UART for 8N1 operation, interrupts disabled, and
 * no hardware flow-control
 *
 * Parameters:
 */
void vfnUart_init (void);

/********************************************************************/
/*
 * Wait for a character to be received on the specified UART
 *
 * Return Values:
 *  the received character
 */
UINT8 u8Uart_getchar (INT16 channel);

/********************************************************************/
/*
 * Wait for space in the UART Tx FIFO and then send a character
 */ 
void vfnUart_putchar (INT16 channel, INT8 ch);

/********************************************************************/
/*
 * Check to see if a character has been received
 *
 * Return values:
 *  0       No character received
 *  1       character has been received
 */

/********************************************************************/
/*
 * Check to see if a character has been received
 *
 * Return values:
 *  0       No character received
 *  1       character has been received
 */
INT16 i16Uart_getchar_present (INT16 channel);


#endif /* __SCI_H__ */
