/********* ascii.c **********/


#include "m51em256demo.h"
#include "sci.h"
#include "ascii.h"
#include "com_protocol.h"


UINT8  RX_status;                      /*Flag used to monitor the transsmision status*/
UINT8  conversion_status;              /*Flag used to monitor the conversion status*/
UINT16 rx_counter;                     /*Used to count received characteres*/
UINT16 hex_counter;

UINT8 received;

/* 
  *  when receives a CR the command is ready and   RX_status = 0x80;
  *  if a message is being received   RX_status = 0x01;
  *  when ch = >   buffer is initialized.
  *  When buffer reaches the end, the received data is saved in the last location
  *  rx1_counter counts the number of bytes received.
  *      
*/

void asciitohex (UINT8 *u8orig, UINT8 *u8dest)
{
  UINT8 temp_converted_value;
  
  temp_converted_value = ascii_to_nibble (*u8orig);
  temp_converted_value = (UINT8)(temp_converted_value<<4);
  
  u8orig++;
  
  temp_converted_value |= ascii_to_nibble (*u8orig);
  
  *u8dest = temp_converted_value;
  
}


UINT8 ascii_to_nibble (UINT8 u8ascii_val)
{
  UINT8 u8converted = 0;
  
  if (u8ascii_val >='a' && u8ascii_val <='f') 
  {
    u8ascii_val &= ~0x20 ;                            /*upper case*/
  }
 
  if (u8ascii_val >='0' && u8ascii_val <='9')        
  {
    u8converted = (UINT8)(u8ascii_val - '0');                
  }
  else if (u8ascii_val >='A' && u8ascii_val <='F')   
  {
    u8converted = (UINT8)(u8ascii_val - 'A' + 0x0A);
  }                                                  
  else
  {
    conversion_status = COMMAND_ERROR;
  }
  return u8converted;
}


/*
  check for a receiver command   RX_status = 0x80;
  
  >xxxxxxxxxxxx<CR>

*/



void buffer_conversion(void)
{
  UINT16 u8index = 0;
  
  if ( (rx_counter & 0x01) || (!rx_counter) )           /*error if received data is odd or zero*/ 
  {
   conversion_status = COMMAND_ERROR;
   return;
  }
  
  for (hex_counter = 0; hex_counter < rx_counter/2; hex_counter++)
  {
    asciitohex ( &RX_Buffer[u8index], &Hex_Buffer[hex_counter] );
    u8index += 2;
  }
}



void hextoascii (UINT8 u8hex_val)
{
 UINT8 u8temp_hexval;
 
 u8temp_hexval = (UINT8)(u8hex_val & 0x0F);             /*backup of the low nibble value*/
 u8hex_val = (UINT8)(u8hex_val>>4);
 u8hex_val &= 0x0F;
 
 send_nibble_as_ascii(u8hex_val);
 send_nibble_as_ascii(u8temp_hexval);
}



void send_nibble_as_ascii (UINT8 u8nibble_val)
{
 if (u8nibble_val >= 0x00 && u8nibble_val <= 0x09)        
 {
   u8nibble_val += '0';                
 }
 else if (u8nibble_val >= 0x0A && u8nibble_val <= 0x0F)   
 {
   u8nibble_val += 'A' - 0x0A;
 }
 
 u8SCI_SendChr(USED_PORT, (INT8)(u8nibble_val));
}



void sendOK (void)
{
  hextoascii (OK);
}



void sendNOK (void)
{
  hextoascii (ERR);
  sendCR();                           /*HEX format*/
}



void sendCR (void)
{
  u8SCI_SendChr(USED_PORT, CR);
  u8SCI_SendChr(USED_PORT, LF);
  u8SCI_SendChr(USED_PORT, LF);
}



void SCI_Data_analisys(UINT8 u8received_data)
{

 if (u8received_data == CR && RX_status == COMMAND_RECEIVING)
 {
  RX_status = COMMAND_RECEIVED;
  return;
 }
 
 if(u8received_data == '>') 
 { 
  rx_counter = 0;                     /*Counts the number of chars received after the command*/                          
  RX_status = COMMAND_RECEIVING;
  return;
 }
  
 if(/*u8received_data != '>' && */RX_status == COMMAND_RECEIVING)
 {  
  if (rx_counter >= RX_BUFFER_SIZE)      
  { 
    rx_counter= RX_BUFFER_SIZE - 1;
    RX_Buffer[0] = 0xFF;              /*Invalids Buffer information*/
    RX_Buffer[1] = 0xFF;              /*Invalids Buffer information*/
  }
  
  RX_Buffer[rx_counter++] = u8received_data;
 }
 
}
 
 

 
  
void Disable_RX(UINT8 port)
{
 switch(port)
  {
    case 1:
    {
      SCI1C2_RE = 0;
    }break;
    
    case 2:
    {
      SCI2C2_RE = 0;
    }break;
     
    case 3:
    {
      SCI3C2_RE = 0;
    }break;
     
    default:
    {
      for(;;){}; /*error*/
    }break;
  }
}
 
 
  
void Enable_RX(UINT8 port)
{
  switch(port)
  {
    case 1:
    {
      SCI1C2_RE = 1;
    }break;
     
    case 2:
    {
      SCI2C2_RE = 1;
    }break;
     
    case 3:
    {
      SCI3C2_RE = 1;
    }break;
     
    default:
    {
      for(;;){}; /*error*/
    }break;
  }
} 
 
 
 

/*******************************************************************************************/ 
/*  FOLLOWING CODE WILL BE COMPILED ONLY FOR THE USED_PORT DEFINED IN com_protocol.c FILE  */
/*******************************************************************************************/
 
#if (USED_PORT == 1)
 void interrupt VectorNumber_Vsci1rx  SCI1_rx_srvc(void) 
 {
  UINT8 u8received_char;
  
  u8SCI_Receivechar(USED_PORT, &u8received_char);
  SCI_Data_analisys(u8received_char);
 }
#endif



#if (USED_PORT == 2)
 void interrupt VectorNumber_Vsci2rx  SCI2_rx_srvc(void) 
 {
  UINT8 u8received_char;
  
  u8SCI_Receivechar(USED_PORT, &u8received_char);
  SCI_Data_analisys(u8received_char);
 }
#endif



#if (USED_PORT == 3)
 void interrupt VectorNumber_Vsci3rx  SCI3_rx_srvc(void) 
 {
  UINT8 u8received_char;
  
  u8SCI_Receivechar(USED_PORT, &u8received_char);
  SCI_Data_analisys(u8received_char);
 }
#endif

 