/******************** Protocol.h ***********************/
/*-----------------------------------------------------*/


/******** DEFINES THE SCI PORT USED AND BAUDRATE *************/
#define USED_PORT     1     /*selects the port used for communication*/
#define BAUDRATE      4800  /*300, 600, 1200, 2400, 4800, 9600 max*/

#define REFERENCE_LEVEL 27  /*Reference voltage used by the comparator*/
                      
#define IR_ACTIVE     1     /* 1=TX INVERTED (reference level used); 0=TX NORMAL (reference level ignored)*/  

/**************** CONSTANTS DEFINITIONS *******************/
#define RX_BUFFER_SIZE 2048
/*Defines the buffer size used for reception*/
#define HEX_BUFFER_SIZE RX_BUFFER_SIZE/2
/*Defines the buffer size used for converted values*/

#define TABLES_NUMBER     4        /*defines number of tables*/

/* TABLEx_SIZE: size of the table in bytes */                       
#define TABLE0_SIZE       64      /*Defines the buffer size of Table 0 (electrical measurements)*/
#define TABLE1_SIZE       32      /*Defines the buffer size of Table 1 (calibration [needs password])*/
#define TABLE2_SIZE       32      /*Defines the buffer size of Table 2 (seetings)*/
#define TABLE3_SIZE       128     /*Defines the buffer size of Table 3 (data logger)*/


/* TABLEx_TYPE: type of the table */
#define R_AND_W   0   /* read and write */
#define R_ONLY    1   /* read only      */
#define W_ONLY    2   /* write only     */                       

#define TABLE0_TYPE   R_AND_W
#define TABLE1_TYPE   R_AND_W
#define TABLE2_TYPE   R_AND_W
#define TABLE3_TYPE   R_AND_W


/* TABLEx_SECURITY: security options of the tables */
#define NONE      0   /* table has not security */
#define PASSWORD  1   /* table needs password to acces */
#define HIDE      2   /* table is not visible */                        

#define TABLE0_SECURITY   NONE
#define TABLE1_SECURITY   NONE
#define TABLE2_SECURITY   NONE
#define TABLE3_SECURITY   NONE


/**************** FLAGS USED IN THE PROTOCOL *****************/
#define COMMAND_RECEIVED   0x80   /*flag used for command received*/
#define COMMAND_RECEIVING  0x01   /*flag used for indicates receiving command*/
#define COMMAND_WAITING    0x00   /*flag used for wait a command*/
#define COMMAND_ERROR      0xFF   /*flag used for error in a command*/
#define WRITE_OK           0x00   /*flag used for sussesful flash write*/
#define WRITE_ERROR        0x01   /*flag used for unsussesful flash write*/


/************ MEMORY ADDRESS FOR RAM AND FLASH ************/
#define RAM_START_ADDRESS      0x00800000      /*VALUE SHOWN IN THE REFERENCE MANUAL*/
#define RAM_END_ADDRESS        0x00803FFF      /*VALUE SHOWN IN THE REFERENCE MANUAL*/

#define FLASH1_START_ADDRESS   0x00000000      /*VALUE SHOWN IN THE REFERENCE MANUAL*/
#define FLASH1_END_ADDRESS     0x0001FFFF      /*VALUE SHOWN IN THE REFERENCE MANUAL*/

#define FLASH2_START_ADDRESS   0x00020000      /*VALUE SHOWN IN THE REFERENCE MANUAL*/
#define FLASH2_END_ADDRESS     0x0003FFFF      /*VALUE SHOWN IN THE REFERENCE MANUAL*/


/************ COMMANDS USED FOR PROTOCOL COMMANDS ************/

#define COMMAND_FULL_READ       0x30
#define FULL_READ_SIZE          3       /*SIZE OF THE FULL READ LENGTH*/
/* <code(8-bit)><tableID(16-bit)>*/

#define COMMAND_OFFSET_READ     0x3F    /*SIZE OF THE OFFSET READ LENGTH*/
#define OFFSET_READ_SIZE        8
/* <code(8-bit)><tableID(16-bit)><offset(24-bit)><octet_count(16-bit)>*/

#define COMMAND_FULL_WRITE      0x40
#define FULL_WRITE_SIZE         5       /*SIZE OF THE FULL WRITE LENGTH WITHOUT DATA AND CHECKSUM*/
/* <code(8-bit)><tableID(16-bit)><octet_count(16-bit)><data><checksum>*/

#define COMMAND_OFFSET_WRITE    0x4F      
#define OFFSET_WRITE_SIZE       8       /*SIZE OF THE OFFSET READ LENGTH WITHOUT DATA AND CHECKSUM*/
/* <code(8-bit)><tableID(16-bit)><offset(24-bit)><octet_count(16-bit)><data><checksum>*/


#define OK  0x00
#define ERR 0x01


/********************** GENERAL VARIABLES USED *****************/
extern UINT8 RX_Buffer[RX_BUFFER_SIZE];      /*Buffer used for SCI RX*/
extern UINT8 Hex_Buffer[HEX_BUFFER_SIZE];    /*Buffer used for converted ASCII to HEX values*/



/********************** STRUCTS FOR TABLE IDENTIFICATORS *****************/
extern struct Table_Description
 {
  UINT8   *address;       /*Table Address*/
  UINT16  size;           /*Table Size*/
  UINT8   type;           /*Table type (read, write, read/write)*/
  UINT8   security;       /*Security options*/
  UINT8   *name[20];      /*Table name*/
 }TableDescript;



/********************** FUNCTION PROTOTYPES *****************/
void communication_protocol(void);
/*This function contains the implementation of the protocol*/    
void full_read(void);
/*Function for Full Read service*/
void offset_read(void);
/*Function for Offset Read service*/
void full_write(void);
/*Function for Full Write service*/
void offset_write(void);
/*Function for Offset Write service*/
UINT8 write_verify(UINT8 *p_memory_address, UINT16 u16element_count, UINT8 *p_data_pointer);
/*Function used for rewrite a table*/