/*^^^^^^^^^^^^^^^^      LCD HARDWARE CONECTION ^^^^^^^^^^^^^^^^^^^^^^^^*/

#define _charNUM (9)



#define _LCDTYPE (4)  // 2 bytes to complete one character


#define  EnableLCDpin(RegNum,LCDn)    LCDPEN##RegNum##_PEN##LCDn = 1
#define  EnableBackplane(RegNum, LCDn)      LCDBPEN##RegNum##_BPEN##LCDn  = 1    



#define  SetBackplane(ComNum, LCDn)    LCDWF##LCDn##  = (1 <<  (##ComNum##))

#define  characterPlace(LCDn)        _LCDWF##LCDn        // _LCDWF0


// Enable all LCD pins to be used as LCD function  inlcuding Backplanes and Front planes
     #define      EnablePin1    EnableLCDpin (0,0)
     #define      EnablePin2    EnableLCDpin (0,1)
     #define      EnablePin3    EnableLCDpin (0,2)
     #define      EnablePin4    EnableLCDpin (0,3)
     #define      EnablePin5    EnableLCDpin (0,4)
     #define      EnablePin6    EnableLCDpin (0,5)
     #define      EnablePin7    EnableLCDpin (0,6)
     #define      EnablePin8    EnableLCDpin (0,7)
     #define      EnablePin9    EnableLCDpin (1,8)
     #define      EnablePin10    EnableLCDpin (1,9)
     #define      EnablePin11    EnableLCDpin (1,10)
     #define      EnablePin12    EnableLCDpin (1,11)
     #define      EnablePin13    EnableLCDpin (3,28)
     #define      EnablePin14    EnableLCDpin (3,29)
     #define      EnablePin15    EnableLCDpin (3,30)
     #define      EnablePin16    EnableLCDpin (3,31)
     #define      EnablePin17    EnableLCDpin (4,32)
     #define      EnablePin18    EnableLCDpin (4,33)
     #define      EnablePin19    EnableLCDpin (4,34)
     #define      EnablePin20    EnableLCDpin (4,35)
     #define      EnablePin21    EnableLCDpin (4,36)
     #define      EnablePin22    EnableLCDpin (4,37)
     #define      EnablePin23    EnableLCDpin (4,38)
     #define      EnablePin24    EnableLCDpin (4,39)
     #define      EnablePin25    EnableLCDpin (5,40)
     #define      EnablePin26    EnableLCDpin (5,41)
     #define      EnablePin27    EnableLCDpin (5,42)
     #define      EnablePin28    EnableLCDpin (5,43)
     #define      EnablePin29    EnableLCDpin (3,27)
     #define      EnablePin30    EnableLCDpin (3,26)
     #define      EnablePin31    EnableLCDpin (3,25)
     #define      EnablePin32    EnableLCDpin (3,24)
     #define      EnablePin33    EnableLCDpin (2,23)
     #define      EnablePin34    EnableLCDpin (2,22)
     #define      EnablePin35    EnableLCDpin (2,21)
     #define      EnablePin36    EnableLCDpin (2,20)
     #define      EnablePin37    EnableLCDpin (2,19)
     #define      EnablePin38    EnableLCDpin (2,18)
     #define      EnablePin39    EnableLCDpin (2,17)
     #define      EnablePin40    EnableLCDpin (2,16)
     #define      EnablePin41    EnableLCDpin (1,15)
     #define      EnablePin42    EnableLCDpin (1,14)
     #define      EnablePin43    EnableLCDpin (1,13)
     #define      EnablePin44    EnableLCDpin (1,12)



/*Related with register names */



// Enable the LCD pin like a Backplane functionality 
// (registernumber,LCD pin number)
        #define EnableCom1         EnableBackplane(0,0)
        #define EnableCom2         EnableBackplane(0,1)
        #define EnableCom3         EnableBackplane(0,2)
        #define EnableCom4         EnableBackplane(0,3)



// Give the mask to the Backplane  
// (ComNumber/BitNumber/priority  segun el LCD manual ,  LCDn)
        #define SetCom1         SetBackplane(0,0)
        #define SetCom2         SetBackplane(1,1)
        #define SetCom3         SetBackplane(2,2)
        #define SetCom4         SetBackplane(3,3)




// Indicate how character is connected to LCDn
#define   char1a        characterPlace (4)  // LCD Pin 5
#define   char1b        characterPlace (5)  // LCD Pin 6
#define   char1c        characterPlace (6)  // LCD Pin 7
#define   char1d        characterPlace (7)  // LCD Pin 8
#define   char2a        characterPlace (8)  // LCD Pin 9
#define   char2b        characterPlace (9)  // LCD Pin 10
#define   char2c        characterPlace (10)  // LCD Pin 11
#define   char2d        characterPlace (11)  // LCD Pin 12
#define   char3a        characterPlace (12)  // LCD Pin 44
#define   char3b        characterPlace (13)  // LCD Pin 43
#define   char3c        characterPlace (14)  // LCD Pin 42
#define   char3d        characterPlace (15)  // LCD Pin 41
#define   char4a        characterPlace (16)  // LCD Pin 40
#define   char4b        characterPlace (17)  // LCD Pin 39
#define   char4c        characterPlace (18)  // LCD Pin 38
#define   char4d        characterPlace (19)  // LCD Pin 37
#define   char5a        characterPlace (20)  // LCD Pin 36
#define   char5b        characterPlace (21)  // LCD Pin 35
#define   char5c        characterPlace (22)  // LCD Pin 34
#define   char5d        characterPlace (23)  // LCD Pin 33
#define   char6a        characterPlace (24)  // LCD Pin 32
#define   char6b        characterPlace (25)  // LCD Pin 31
#define   char6c        characterPlace (26)  // LCD Pin 30
#define   char6d        characterPlace (27)  // LCD Pin 29
#define   char7a        characterPlace (28)  // LCD Pin 13
#define   char7b        characterPlace (29)  // LCD Pin 14
#define   char7c        characterPlace (30)  // LCD Pin 15
#define   char7d        characterPlace (31)  // LCD Pin 16
#define   char8a        characterPlace (32)  // LCD Pin 17
#define   char8b        characterPlace (33)  // LCD Pin 18
#define   char8c        characterPlace (34)  // LCD Pin 19
#define   char8d        characterPlace (35)  // LCD Pin 20
#define   char9a        characterPlace (36)  // LCD Pin 21
#define   char9b        characterPlace (37)  // LCD Pin 22
#define   char9c        characterPlace (38)  // LCD Pin 23
#define   char9d        characterPlace (39)  // LCD Pin 24

          






 #define SymbolOFF(LCDn,Mask)               LCDWF##LCDn   &=  ~(1<<(Mask))         
#define SymbolON(LCDn,Mask)               LCDWF##LCDn   |=  (1<<(Mask))
//  (LCDn, BitNumber)


#define   _LCD_FREESCALE_ON()      SymbolON(14,3)
#define   _LCD_FIRE_ON()      SymbolON(15,3)
#define   _LCD_SNOW_ON()      SymbolON(19,3)
#define   _LCD_CLOCK_ON()      SymbolON(26,3)
#define   _LCD_BATTERY_ON()      SymbolON(27,3)
#define   _LCD_VOLUME_ON()      SymbolON(42,0)
#define   _LCD_PWR_SAVE_ON()      SymbolON(30,3)
#define   _LCD_V1_ON()      SymbolON(39,3)
#define   _LCD_V2_ON()      SymbolON(40,0)
#define   _LCD_V3_ON()      SymbolON(42,1)
#define   _LCD_V4_ON()      SymbolON(42,2)
#define   _LCD_V5_ON()      SymbolON(42,3)
#define   _LCD_DATE_ON()      SymbolON(10,3)
#define   _LCD_OHM_ON()      SymbolON(40,3)
#define   _LCD_DT1_ON()      SymbolON(7,2)
#define   _LCD_DT2_ON()      SymbolON(11,3)
#define   _LCD_DT3_ON()      SymbolON(15,2)
#define   _LCD_DT4_ON()      SymbolON(19,2)
#define   _LCD_DT5_ON()      SymbolON(23,3)
#define   _LCD_DT6_ON()      SymbolON(27,2)
#define   _LCD_DT7_ON()      SymbolON(31,3)
#define   _LCD_DT8_ON()      SymbolON(35,2)
#define   _LCD_DT9_ON()      SymbolON(39,2)
#define   _LCD_COL1_ON()      SymbolON(11,2)
#define   _LCD_COL2_ON()      SymbolON(23,2)
#define   _LCD_COL3_ON()      SymbolON(31,2)
#define   _LCD_COL4_ON()      SymbolON(38,3)
#define   _LCD_MINUS_ON()      SymbolON(7,3)
#define   _LCD_KWhr_ON()      SymbolON(41,0)
#define   _LCD_Amp_ON()      SymbolON(41,1)
#define   _LCD_Volts_ON()      SymbolON(41,2)
#define   _LCD_Program_ON()      SymbolON(41,3)
#define   _LCD_AM_ON()      SymbolON(40,1)
#define   _LCD_PM_ON()      SymbolON(40,2)
#define   _LCD_TEMP_ON()      SymbolON(7,3)
#define   _LCD_CONTRAST_ON()      SymbolON(34,3)
#define   _LCD_MODE_ON()      SymbolON(35,3)

// symbol off

#define   _LCD_FREESCALE_OFF()      SymbolOFF(14,3)
#define   _LCD_FIRE_OFF()      SymbolOFF(15,3)
#define   _LCD_SNOW_OFF()      SymbolOFF(19,3)
#define   _LCD_CLOCK_OFF()      SymbolOFF(26,3)
#define   _LCD_BATTERY_OFF()      SymbolOFF(27,3)
#define   _LCD_VOLUME_OFF()      SymbolOFF(42,0)
#define   _LCD_PWR_SAVE_OFF()      SymbolOFF(30,3)
#define   _LCD_V1_OFF()      SymbolOFF(39,3)
#define   _LCD_V2_OFF()      SymbolOFF(40,0)
#define   _LCD_V3_OFF()      SymbolOFF(42,1)
#define   _LCD_V4_OFF()      SymbolOFF(42,2)
#define   _LCD_V5_OFF()      SymbolOFF(42,3)
#define   _LCD_DATE_OFF()      SymbolOFF(10,3)
#define   _LCD_OHM_OFF()      SymbolOFF(40,3)
#define   _LCD_DT1_OFF()      SymbolOFF(7,2)
#define   _LCD_DT2_OFF()      SymbolOFF(11,3)
#define   _LCD_DT3_OFF()      SymbolOFF(15,2)
#define   _LCD_DT4_OFF()      SymbolOFF(19,2)
#define   _LCD_DT5_OFF()      SymbolOFF(23,3)
#define   _LCD_DT6_OFF()      SymbolOFF(27,2)
#define   _LCD_DT7_OFF()      SymbolOFF(31,3)
#define   _LCD_DT8_OFF()      SymbolOFF(35,2)
#define   _LCD_DT9_OFF()      SymbolOFF(39,2)
#define   _LCD_COL1_OFF()      SymbolOFF(11,2)
#define   _LCD_COL2_OFF()      SymbolOFF(23,2)
#define   _LCD_COL3_OFF()      SymbolOFF(31,2)
#define   _LCD_COL4_OFF()      SymbolOFF(38,3)
#define   _LCD_MINUS_OFF()      SymbolOFF(7,3)
#define   _LCD_KWhr_OFF()      SymbolOFF(41,0)
#define   _LCD_Amp_OFF()      SymbolOFF(41,1)
#define   _LCD_Volts_OFF()      SymbolOFF(41,2)
#define   _LCD_Program_OFF()      SymbolOFF(41,3)
#define   _LCD_AM_OFF()      SymbolOFF(40,1)
#define   _LCD_PM_OFF()      SymbolOFF(40,2)
#define   _LCD_TEMP_OFF()      SymbolOFF(7,3)
#define   _LCD_CONTRAST_OFF()      SymbolOFF(34,3)
#define   _LCD_MODE_OFF()      SymbolOFF(35,3)



 
#define MapSegment(SegmentName,Mask)   (1<<(##Mask##)) 
          
          #define  SEG1               MapSegment (H,0)
          #define  SEG2               MapSegment (F,1)
          #define  SEG3               MapSegment (E,2)
          #define  SEG4               MapSegment (N,3)

          #define  SEG5               MapSegment (A,0)
          #define  SEG6               MapSegment (J,1)
          #define  SEG7               MapSegment (G,2)
          #define  SEG8               MapSegment (M,3)
          
          
          #define  SEG9               MapSegment (K,0)
          #define  SEG10              MapSegment (L,1)
          #define  SEG11              MapSegment (D,2)
          
          
          #define  SEG12              MapSegment (B,0)
          #define  SEG13              MapSegment (C,1)


/*Map segment to COM mask*/
#define  SEGB   0x01
#define  SEGC   0x02

#define  SEGH   0x01
#define  SEGF   0x02
#define  SEGE   0x04
#define  SEGN   0x08

#define  SEGA   0x01
#define  SEGJ   0x02
#define  SEGG   0x04
#define  SEGM   0x08

#define  SEGK   0x01
#define  SEGL   0x02
#define  SEGD   0x04


//Ascii table American Standar
#define _ALLON  (SEG1  | SEG2 | SEG3 | SEG4)  



