/* 


*/


/*^^^^^^^^^^^^^^^^      LCD Configuration                        ^^^^^^^^^^^^^^^^^^^^^^^^*/
#define _LCDBACKPLANES (4)                              // # of backplanes - 1 
#define _LCDCPSEL        (1)                             //0 -- Resistor network   1 -- charge pump  
#define _LCDVSUPPLY              (3)                             //0  --  VLL2 from VDD    1 --   VLL3 from VDD  2 -- VLL1 from VLCD  3 -- VLL3 external or from VIREG
#define _LCDLOADADJUST     (0)                            // CPSEL = 1     0 -- 8000 pf 1 -- 6000 pf  2 -- 4000 pf  3 -- 2000 pf
#define _LCDBLINKRATE          (0)                           //Any number between 0 and 7 
                                                                                            
/*{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{        Functions        }}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}*/
/*{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{   ----------------------------  }}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}*/

/*||||||||||||||||||||||       vfnLCD_Init            ||||||||||||||||||||||
brief:  Initialize all the registers on the mcu module 
param:  void                            return:  void    
*/  
void vfnLCD_Init  (void);

/*||||||||||||||||||||||       vfnLCD_EnablePins   ||||||||||||||||||||
brief: Enable all the pins of the mcu directly connected to the  LCD on use
param:  void                            return:  void    
*/  
void vfnEnablePins (void);

 /*||||||||||||||||||||||       vfnLCD_Enab leBackplanes ||||||||||||||
brief: Enable the function of Backplane in the pin
param:  void                            return:  void    
*/  
void vfnEnableBackplanes (void);

 /*||||||||||||||||||||||       vfnLCD_SetBackplanes ||||||||||||||
brief:  Set as a backplane and give the number of COM that corresponds  
param:  void                            return:  void    
*/
void vfnSetBackplanes (void);

/*||||||||||||||||||||||       vfnLCD_Home            ||||||||||||||||||||||
brief:  Reset the counter to the first position
param:  void
return:  void    
*/  




void vfnLCD_Home (void);
 /*||||||||||||||||||||||       vfnLCD_Write_char   ||||||||||||||||||||||
 brief:  Writes on char after the last character was write
 param:  byte --- Ascii to write                            return:  void    
*/
void vfnLCD_Write_char (byte lbValue);


/*
   Send a message until a end of char or max number of characters
   
   if the message size is greater than LCD character the message is cut ad the size of LCD characters
   
   If the message lenght is minor than Display character is filled with Blanks
   
 */
void  vfnLCD_Write_New_Msg (byte *lbpMessage);
 
 /*||||||||||||||||||||||       vfnLCD_Scroll    ||||||||||||||||||||||
brief:  Moves the message on the LCD 
param:  byte pointer --- the first character  on the array to write
param: byte --- the size of the character  
return:  void    
*/


 /*||||||||||||||||||||||       vfnLCD_Write_Msg    ||||||||||||||||||||||
brief:  Writes on message on the LCD   if the message is longer than the number of character  is send to the Scroll function
param:  byte pointer --- the first character  on the array to write
param: byte --- the numbers of characterts to write      
return:  void    
*/
void  vfnLCD_Write_Msg (byte *lbpMessage, byte lbSize );

void vfnLCD_Scroll (byte *lbpMessage,byte lbSize);

 /*||||||||||||||||||||||       vfnLCD_All_Segments_ON   ||||||||||||||||||||||
brief: Turns on all the segments on the LCD
param:  byte pointer --- the first character  on the array to write
param: byte --- the size of the character  
return:  void    
*/
void vfnLCD_All_Segments_ON (void);
                                                                                                      

/*Same as clear dispay */
void vfnLCD_All_Segments_OFF (void);



