/********************************************************************

  SCII1, SCI2, SCI3

  SCI1 connected to IR
  SCI2 to uart

********************************************************************/

#include "m51em256demo.h" /* include peripheral declarations */

void RF_init(UINT8 port)
{
	/*
	 * Initialize all three UARTs for serial communications
	 */
	register UINT16 ubgs;
  
  switch(port)
  {
    case 0:
      /*SCI function*/
      PTBPF2_B2 = 3;
      PTBPF2_B3 = 3;
      /*FSL:use CMP2P1 for "demodulation"*/    

      /*starting SCI clock*/
      SCGC1_SCI1 = 1;

    	/*
    	 * Calculate baud settings
    	 */
    	/* FSL:check this formula!!! */
    	ubgs = (UINT16)((BUS_CLOCK)/(UART_BAUD * 16));

    	SCI1BDH = (UINT8)((ubgs & 0xFF00) >> 8);
    	SCI1BDL = (UINT8)(ubgs & 0x00FF);
    
      /* 8-bit mode. Normal operation */
      SCI1C1 = NULL;
      /* Receiver interrupt enable. Transmitter and receiver enable */
      SCI1C2 = (0
               | SCI1C2_TE_MASK
               | SCI1C2_RE_MASK
               );
      /* Disable all errors interrupts */  
      SCI1C3 = NULL;

    	break;
    case 1:
      /*SCI function*/
      PTBPF2_B0 = 3;/*FSL:use CMP1P1 for "demodulation"*/
      PTBPF2_B1 = 3;    

      /* starting SCI clock */
      SCGC1_SCI2 = 1;
    	/*
    	 * Calculate baud settings
    	 */
    	/* FSL:check this formula!!! */
    	ubgs = (UINT16)((BUS_CLOCK)/(UART_BAUD * 16));

    	SCI2BDH = (UINT8)((ubgs & 0xFF00) >> 8);
    	SCI2BDL = (UINT8)(ubgs & 0x00FF);
    
      /* 8-bit mode. Normal operation */
      SCI2C1 = NULL;
      /* Receiver interrupt enable. Transmitter and receiver enable */
      SCI2C2 = (0
               | SCI1C2_TE_MASK
               | SCI1C2_RE_MASK
               );
      /* Disable all errors interrupts */  
      SCI2C3 = NULL;
    	break;    
  }  
}
