#include "m51em256demo.h"
#include "sci.h"
#include "infrared.h"

#define IR_PORT       1
#define WIRED_PORT    3
/* THESE PORTS CAN NOT BE THE SAME!!!!! */

#define BAUDRATE      4800
/*1200, 2400, 4800, 9600 max*/

#define REFERENCE_LEVEL 27

#define COMPARATOR_USED       1
#define DRIVE_STRENGTH_USED   1
/*0 disables the function; 1 enables the function

/*****************************************************************************************************
                                    Function Prototypes
*****************************************************************************************************/

void system_clock_init(void);
void Disable_IR_RX(UINT8 port);
void IR_transmission(UINT8 port, UINT8 data);

/*****************************************************************************************************
                                    START OF MAIN
*****************************************************************************************************/

void main(void) 
{
  system_clock_init();
  
  /*Initializes the SCI used for infrared communication*/
  if(u8SCI_init(IR_PORT, BAUDRATE, DATA_LENGTH_EIGTH, PARITY_NONE, TX_INVERTED, RX_NOT_INVERTED))for(;;){};        
  if(u8IR_RX_init(IR_PORT, RX_PIN_OPTION_DEFAULT, (COMPARATOR_USED*REFERENCE_LEVEL), RX_INTERRUPT_ENABLED))for(;;){};
  if(u8IR_TX_init(IR_PORT, TX_PIN_OPTION_DEFAULT, DRIVE_STRENGTH_USED, MODULATION_DISABLED, TX_INTERRUPT_DISABLED))for(;;){};
  
  /*Initializes the SCI used for wired communication*/
  if(u8SCI_init(WIRED_PORT, BAUDRATE, DATA_LENGTH_EIGTH, PARITY_NONE, TX_NOT_INVERTED, RX_NOT_INVERTED))for(;;){}; 
  if(u8IR_RX_init(WIRED_PORT, RX_PIN_OPTION_DEFAULT, COMPARATOR_DISABLED, RX_INTERRUPT_ENABLED))for(;;){};  
  if(u8IR_TX_init(WIRED_PORT, TX_PIN_OPTION_DEFAULT, DRIVE_STRENGTH_DISABLED, MODULATION_DISABLED, TX_INTERRUPT_DISABLED))for(;;){};
  
  /*if FOR cycle occurs, there is error*/   
  
  EnableInterrupts; /* enable interrupts */
  
  for(;;)
  {
      
  }/* loop forever */
   /* please make sure that you never leave main */
}


/*****************************************************************************************************
                                     END OF MAIN
*****************************************************************************************************/

void system_clock_init(void)
 {
  SOPT1_COPT = 0;       /* Turns off the watchdog timer */
  ICSC2_BDIV = 0;       /* Divider = clock/1 */
  ICSSC_DRST_DRS = 2;   /* High range mode */
 }

/*****************************************************************************************************/
/*****************************************************************************************************/

void Disable_IR_RX(UINT8 port)
{
 switch(port)
  {
    case 1:
    {
      SCI1C2_RE = 0;
    }break;
    
    case 2:
    {
      SCI2C2_RE = 0;
    }break;
    
    case 3:
    {
      SCI3C2_RE = 0;
    }break;
    
    default:
    {
      for(;;){}; /*error*/
    }break;
  }
}

/*****************************************************************************************************/
/*****************************************************************************************************/

void IR_transmission(UINT8 port, UINT8 data)
{
  switch(port)
  {
    case 1:
    {
      SCI1C2_RE = 0;
      while(!SCI1S1_TC){};
      SCI1D = data;
      SCI1C2_TCIE = 1; /*enables interrupt for transmission completed */
    }break;
    
    case 2:
    {
      SCI2C2_RE = 0;
      while(!SCI2S1_TC){};
      SCI2D = data;
      SCI2C2_TCIE = 1; /*enables interrupt for transmission completed */
    }break;
    
    case 3:
    {
      SCI3C2_RE = 0;
      while(!SCI3S1_TC){};
      SCI3D = data;
      SCI3C2_TCIE = 1; /*enables interrupt for transmission completed */
    }break;        
    
    default:
    {
      for(;;){} /*error*/
    }
  }
}

/*****************************************************************************************************/
/*****************************************************************************************************/

 

/*******************************************************************************************/ 
/*                          ===INTERRUPT VECTORS===                                        */
/*         FOLLOWING CODE WILL BE COMPILED ONLY FOR THE PORTS DEFINED                      */
/*******************************************************************************************/
 
#if (IR_PORT == 1)
 void interrupt VectorNumber_Vsci1rx  SCI1_rx_srvc(void) 
 {
  UINT8 u8received_char;
  
  (void)SCI1S1;
  u8received_char = SCI1D;
  u8SCI_SendChr(WIRED_PORT, u8received_char);
 }
 
 void interrupt VectorNumber_Vsci1tx  SCI1_tx_srvc(void) 
 {
   SCI1C2_TCIE = 0; /*disable transmission interrupt*/
   SCI1C2_RE = 1;
 }
#endif


#if (IR_PORT == 2)
 void interrupt VectorNumber_Vsci2rx  SCI2_rx_srvc(void) 
 {
  UINT8 u8received_char;
   
  (void)SCI2S1;
  u8received_char = SCI2D;
  u8SCI_SendChr(WIRED_PORT, u8received_char);
 }
 
 void interrupt VectorNumber_Vsci2tx  SCI2_tx_srvc(void) 
 {
   SCI2C2_TCIE = 0; /*disable transmission interrupt*/
   SCI2C2_RE = 1;
 }
#endif


#if (IR_PORT == 3)
 void interrupt VectorNumber_Vsci3rx  SCI3_rx_srvc(void) 
 {
  UINT8 u8received_char;
 
  (void)SCI3S1; 
  u8received_char = SCI3D;
  u8SCI_SendChr(WIRED_PORT, u8received_char);
 }
 
 void interrupt VectorNumber_Vsci3tx  SCI3_tx_srvc(void) 
 {
   SCI3C2_TCIE = 0; /*disable transmission interrupt*/
   SCI3C2_RE = 1;
 }
#endif


#if (WIRED_PORT == 1)
 void interrupt VectorNumber_Vsci1rx  SCI1_rx_srvc(void) 
 {
  UINT8 u8received_char;
 
  (void)SCI1S1; 
  u8received_char = SCI1D;
    
  IR_transmission(IR_PORT, u8received_char);
 }                        
#endif


#if (WIRED_PORT == 2)
 void interrupt VectorNumber_Vsci2rx  SCI2_rx_srvc(void) 
 {
  UINT8 u8received_char;
 
  (void)SCI2S1; 
  u8received_char = SCI2D;
  
  IR_transmission(IR_PORT, u8received_char); 
 }
#endif


#if (WIRED_PORT == 3)
 void interrupt VectorNumber_Vsci3rx  SCI3_rx_srvc(void) 
 {
  UINT8 u8received_char;

  (void)SCI3S1;
  u8received_char = SCI3D;
  
  IR_transmission(IR_PORT, u8received_char);
 }
#endif

