/*
 * File:        qspi.h
 * Purpose:     QSPI buffer structure information
 *
 * Notes:
 */

#ifndef __QSPI_H__
#define __QSPI_H__

/********************************************************************/

#define QSPI_TRANSMIT_ADDRESS   0x00          /*QSPI RAM transmit address*/
#define QSPI_RECEIVE_ADDRESS    0x10          /*QSPI RAM receive address*/
#define QSPI_COMMAND_ADDRESS    0x20          /*QSPI RAM command address*/

#define QSPI_BUFFER_CAPACITY	16
#define QSPI_STANDAR_CONFIGURATION

#define GET_MCF_QSPI_QWR_CPTQP  ((MCF_QSPI_QWR>>4)&0x000F)
#define QSPI_QCD_DELAY			0
#define QSPI_DTL_DELAY			0

#define RESCUE_VALUE    	0x10000

/* error codes */
#define ERROR					1
#define NO_ERROR				0

/* Structure for storing qspi information */
typedef struct 
{
	uint8  receive_flag;
	uint8  bits_per_data;
	uint16 *data;
	uint32 size;
}qspi_state_t;

/* Function prototypes */

void QSPIinit();
uint8 QSPIsendReceive(qspi_state_t * qspi_state);

/********************************************************************/

#endif /* __QSPI_H__ */