/*
 * File:        ezport.h
 * Purpose:     EZPORT buffer structure information
 *
 * Notes:
 */

#ifndef __EZPORT_H__
#define __EZPORT_H__

/********************************************************************/

/* structure holding least significant bits for RSTO and RSTI pins */
typedef struct 
{
	uint8 pad  : 6;
	uint8 bit1 : 1;
	uint8 bit0 : 1;
} my_port;

/********************BOARD DEPENDENT START********************/

/* Selecting PORTTC to handle RSTO and RSTI for the other board */

/****OUT PORT*****/
/* mapping our variable to register space: MCF_GPIO_PORTTC */
#define EXTERNAL_PORT_OUT (*(my_port *)(void *)(&__IPSBAR[0x10000F]))

/****DIRECTION PORT*****/
/* mapping our variable to register space: MCF_GPIO_DDRTC */
#define EXTERNAL_PORT_DDR (*(my_port *)(void *)(&__IPSBAR[0x100023]))

/****IN PORT*****/
/* mapping our variable to register space: MCF_GPIO_SETTC */
#define EXTERNAL_PORT_IN  (*(my_port *)(void *)(&__IPSBAR[0x100037]))

/****PIN FUNCTION PORT*****/
/* turning to gpio */
#define EZPORT_GPIO_CONFIG	MCF_GPIO_PTCPAR&=~(0|\
                            MCF_GPIO_PTCPAR_PTCPAR0(3)|\
                            MCF_GPIO_PTCPAR_PTCPAR1(3))


/* definitions to use */
#define EZPORT_RSTOUT_OUT 	EXTERNAL_PORT_OUT.bit0
#define EZPORT_RSTIN_OUT 	EXTERNAL_PORT_OUT.bit1

#define EZPORT_RSTOUT_DDR 	EXTERNAL_PORT_DDR.bit0
#define EZPORT_RSTIN_DDR 	EXTERNAL_PORT_DDR.bit1

#define EZPORT_RSTOUT_IN 	EXTERNAL_PORT_IN.bit0
#define EZPORT_RSTIN_IN 	EXTERNAL_PORT_IN.bit1

#define TIME_OUT_VALUE		0xFFFF

/* 200 KHz @ 48MHz */
#define CLOCK_5213	 	 	0x4E

/********************BOARD DEPENDENT END********************/

/* EzPort command codes */
#define EZPORT_WREN      0x06
#define EZPORT_WRDI      0x04
#define EZPORT_RDSR      0x05
#define EZPORT_WRCR      0x01
#define EZPORT_READ      0x03
#define EZPORT_FAST_READ 0x0B
#define EZPORT_PP        0x02
#define EZPORT_SE        0xD8
#define EZPORT_BE        0xC7
#define EZPORT_RESET     0xB9

/* Status Register Bits */
#define EP_SR_FS      	 0x80  /* Flash in Secure Mode */
#define EP_SR_NFS     	 0x00  /* Flash not in Secure Mode */
#define EP_SR_WEF     	 0x40
#define EP_SR_CRL     	 0x20
#define EP_SR_WEN     	 0x02
#define EP_SR_WIP     	 0x01

/* Configuration Register Bits */
#define EP_CR_PRDIV8  	 0x40
#define EP_CR_DIV     	 0x3F

/* Misc Definitions */
#define DONT_CARE		 0
#define ERROR		 	 1

/* Function prototypes */

uint8 EzPORTinit();
uint8 EzPORTerase();
uint8 EzPORTs19(uint32 address, uint8 *buffer, uint32 length, uint8 verify);
uint8 EzPORTmode();

/* Internal function prototypes */

uint8 EzPORT_WREN();
uint8 EzPORT_WRDI();
uint8 EzPORT_BE();
uint8 EzPORT_RESET();
uint8 EzPORT_WRCR(uint8 data);
uint8 EzPORT_RDSR(uint8 *data);
uint8 EzPORT_PP(uint32 address, uint32 size, void *data);
uint8 EzPORT_SE(uint32 address);
uint8 EzPORT_FAST_READ(uint32 address, uint32 size, void *data);
uint8 EzPORT_READ(uint32 address, uint32 size, void *data);


/********************************************************************/

#endif /* __EZPORT_H__ */