/* 5213 Unity System */

#pragma cplusplus off
#include "metrowerks_UART.h"
#include "uart/uart.h"
#include "common.h"

/****************************************************************************/
void
uart_putchar (int channel, char ch);

UARTError InitializeUART(UARTBaudRate baudRate)
{
	return kUARTNoError;
}

/****************************************************************************/
/*
	ReadUARTN
	
	Read N bytes from the UART.
	
	bytes			pointer to result buffer
	limit			size of buffer and # of bytes to read
*/
/****************************************************************************/
UARTError ReadUARTN(void* bytes, unsigned long limit)
{
	int count;
	UARTError err= kUARTNoError; 

	for (count = 0; count < limit; count++) {
    *( (char *)bytes + count )=uart_getchar(0);
  }
	return err;
}

/****************************************************************************/

UARTError WriteUARTN(const void* bytes, unsigned long length)
{
	int count;
	UARTError err= kUARTNoError; 

	for (count = 0; count < length; count++) {
    uart_putchar(0, *( ((char *)bytes) + count));
  }
	return err;
}

