/************************************************************
  DEMOEM demonstration software - file: main.c
************************************************************/


#include "m51em256evb.h" /* include peripheral declarations */
#include "stdlib.h"
#include "lcd.h"
#include "task_mgr.h"
#include "Metering_algorithm_Tests.h"
                                
/*
   Task variables   
*/
void (*ptr_next_task)(void);   //task pointer
unsigned long timer_task;      // timer runs 1 msec
unsigned char LCD_buffer[10];  // timer runs 1 msec

//Initialization prototypes
void MCU_init(void);
void GPIO_init(void);
void IRTC_Init(void);
void RTC_Interrupt(void);
/************************************************************
     main()  Demo application
*************************************************************/

void main(void) 
{
                    
  MCU_init();      // Initialize MCU
  GPIO_init();
  IRTC_Init();
  TPM_Init();
  uart_init();     //SCI2 is used for printf.  
  vfnLCD_Init();
  next_task_t(tsk_welcome,0);
  
  EnableInterrupts;
  
  for(;;) 
   {
    ptr_next_task();  // do the actual function:  What message is displayed
   }
}

//**********************Main End*****************************/


/******************************************************************
    MCU 
 ****************************************************************/
/*
  Configure Push-buttons inputs
*/
void MCU_init(void) 
 {
  SOPT1 = 0; // Disable COP
  ICSTRM = 0xA1;
  /* ICSC1: CLKS=0,RDIV=0,IREFS=1,IRCLKEN=0,IREFSTEN=0 */
  ICSC1 = 0x04;                        /* Initialization of the ICS control register 1 */
  /* ICSC2: BDIV=0,RANGE=0,HGO=0,LP=0,EREFS=0,ERCLKEN=0,EREFSTEN=0 */
  ICSC2 = 0x00;                        /* Initialization of the ICS control register 2 */
  while(!ICSSC_IREFST) {               /* Wait until the source of reference clock is internal clock */
  }
  /* ICSSC: DRST_DRS=2,DMX32=0 */
  ICSSC = (ICSSC & (unsigned char)~0x60) | (unsigned char)0x80; /* Initialization of the ICS status and control */
  while((ICSSC & 0xC0) != 0x80) {      /* Wait until the FLL switches to High range DCO mode */
  }

 }
 
/******************************************************************
  GPIO initialization
 ****************************************************************/
void GPIO_init(void) 
 {
  SW1_PE = 1;
  SW2_PE = 1;
  SW3_PE = 1;
  SW4_PE = 1;

  LED1_DD = 1;
  LED2_DD = 1;
  LED3_DD = 1;
  LED4_DD = 1;
  
  LED1_OFF();
  LED2_OFF();
  LED3_OFF();
  LED4_OFF();
 }
 
/******************************************************************
  GPIO initialization
 ****************************************************************/ 
void IRTC_Init(void){

   if(RTC_STATUS_WPE==1){
     
     RTC_CTRL_WE = 0b00;        //Disable protection sequence  
     RTC_CTRL_WE = 0b01;        //Disable protection sequence     
     RTC_CTRL_WE = 0b11;        //Disable protection sequence     
     RTC_CTRL_WE = 0b10;        //Disable protection sequence 
     RTC_IER_TMPR = 0;
     RTC_ISR_TMPR = 1;          // Clear Tamper interrupt flag.

   }else{
   
     RTC_IER_TMPR = 0;
     RTC_ISR_TMPR = 1;          // Clear Tamper interrupt flag.
   
   }

   RTC_CTRL_WE = 0b10;         //Enable protection
   if((RTC_IER_TMPR==1)||(RTC_ISR_TMPR==1)){
     while(1)LED1_TOGGLE();
   }
 
}

__interrupt void RTC_Interrupt(void){
   LED4_TOGGLE();
}